/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventNotifierProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(EventNotifierProducer.class);
    private final AsyncProducer producer;

    public EventNotifierProducer(Producer producer) {
        super(producer.getEndpoint());
        this.producer = AsyncProcessorConverterHelper.convert((Producer)producer);
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException((Throwable)new IllegalStateException("Producer has not been started: " + String.valueOf((Object)this)));
            callback.done(true);
            return true;
        }
        boolean sending = EventHelper.notifyExchangeSending((CamelContext)exchange.getContext(), (Exchange)exchange, (Endpoint)this.getEndpoint());
        final StopWatch watch = sending ? new StopWatch() : null;
        try {
            LOG.debug(">>>> {} {}", (Object)this.getEndpoint(), (Object)exchange);
            return this.producer.process(exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(boolean doneSync) {
                    try {
                        if (watch != null) {
                            long timeTaken = watch.taken();
                            EventHelper.notifyExchangeSent((CamelContext)exchange.getContext(), (Exchange)exchange, (Endpoint)EventNotifierProducer.this.getEndpoint(), (long)timeTaken);
                        }
                    }
                    finally {
                        callback.done(doneSync);
                    }
                }
            });
        }
        catch (Exception throwable) {
            exchange.setException((Throwable)throwable);
            callback.done(true);
            return true;
        }
    }

    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.producer);
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.producer);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Service)this.producer);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.producer);
    }
}

