/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashSet;
import java.util.Map;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimCheckAggregationStrategy
implements AggregationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimCheckAggregationStrategy.class);
    private String filter;

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        String part;
        if (newExchange == null) {
            return oldExchange;
        }
        if (ObjectHelper.isEmpty((String)this.filter) || "*".equals(this.filter)) {
            oldExchange.getMessage().setBody(newExchange.getMessage().getBody());
            LOG.trace("Including: body");
            if (newExchange.getMessage().hasHeaders()) {
                oldExchange.getMessage().getHeaders().putAll(newExchange.getMessage().getHeaders());
                LOG.trace("Including: headers");
            }
            return oldExchange;
        }
        if (this.isBodyEnabled()) {
            oldExchange.getMessage().setBody(newExchange.getMessage().getBody());
            LOG.trace("Including: body");
        }
        if (this.isHeadersEnabled() && newExchange.getMessage().hasHeaders()) {
            oldExchange.getMessage().getHeaders().putAll(newExchange.getMessage().getHeaders());
            LOG.trace("Including: headers");
        }
        if (this.hasHeaderPatterns()) {
            boolean excludeOnly = this.isExcludeOnlyHeaderPatterns();
            for (Map.Entry header : newExchange.getMessage().getHeaders().entrySet()) {
                String key = (String)header.getKey();
                if (this.hasHeaderPattern(key)) {
                    boolean include = this.isIncludedHeader(key);
                    boolean exclude = this.isExcludedHeader(key);
                    if (include) {
                        LOG.trace("Including: header:{}", (Object)key);
                        oldExchange.getMessage().getHeaders().put(key, header.getValue());
                        continue;
                    }
                    if (exclude) {
                        LOG.trace("Excluding: header:{}", (Object)key);
                        continue;
                    }
                    LOG.trace("Skipping: header:{}", (Object)key);
                    continue;
                }
                if (!excludeOnly) continue;
                LOG.trace("Including: header:{}", (Object)key);
                oldExchange.getMessage().getHeaders().put(key, header.getValue());
            }
        }
        if (ObjectHelper.isNotEmpty((String)this.filter)) {
            Iterable it = org.apache.camel.support.ObjectHelper.createIterable((String)this.filter, (String)",");
            for (Map.Entry k : it) {
                part = k.toString();
                if ("body".equals(part) || "+body".equals(part)) {
                    oldExchange.getMessage().setBody(newExchange.getMessage().getBody());
                    LOG.trace("Including: body");
                    continue;
                }
                if (!"headers".equals(part) && !"+headers".equals(part)) continue;
                oldExchange.getMessage().getHeaders().putAll(newExchange.getMessage().getHeaders());
                LOG.trace("Including: headers");
            }
        }
        Iterable it = org.apache.camel.support.ObjectHelper.createIterable((String)this.filter, (String)",");
        for (Map.Entry k : it) {
            part = k.toString();
            if ("--body".equals(part)) {
                oldExchange.getMessage().setBody(null);
                continue;
            }
            if ("--headers".equals(part)) {
                oldExchange.getMessage().getHeaders().clear();
                continue;
            }
            if (!part.startsWith("--header:")) continue;
            String after = StringHelper.after((String)part, (String)"--header:");
            Iterable i = org.apache.camel.support.ObjectHelper.createIterable((String)after, (String)",");
            HashSet<String> toRemoveKeys = new HashSet<String>();
            for (Object o : i) {
                String pattern = o.toString();
                for (Map.Entry header : oldExchange.getMessage().getHeaders().entrySet()) {
                    String key = (String)header.getKey();
                    boolean matched = PatternHelper.matchPattern((String)key, (String)pattern);
                    if (!matched) continue;
                    toRemoveKeys.add(key);
                }
            }
            for (String key : toRemoveKeys) {
                LOG.trace("Removing: header:{}", (Object)key);
                oldExchange.getMessage().removeHeader(key);
            }
        }
        return oldExchange;
    }

    private boolean hasHeaderPatterns() {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--") || !pattern.startsWith("header:") && !pattern.startsWith("+header:") && !pattern.startsWith("-header:")) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludeOnlyHeaderPatterns() {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--") || !pattern.startsWith("header:") && !pattern.startsWith("+header:")) continue;
            return false;
        }
        return true;
    }

    private boolean hasHeaderPattern(String key) {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--")) continue;
            String header = null;
            if (pattern.startsWith("header:") || pattern.startsWith("+header:")) {
                header = StringHelper.after((String)pattern, (String)"header:");
            } else if (pattern.startsWith("-header:")) {
                header = StringHelper.after((String)pattern, (String)"-header:");
            }
            if (header == null || !PatternHelper.matchPattern((String)key, (String)header)) continue;
            return true;
        }
        return false;
    }

    private boolean isIncludedHeader(String key) {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--")) continue;
            if (pattern.startsWith("header:") || pattern.startsWith("+header:")) {
                pattern = StringHelper.after((String)pattern, (String)"header:");
            }
            if (!PatternHelper.matchPattern((String)key, (String)pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludedHeader(String key) {
        String[] parts;
        for (String pattern : parts = this.filter.split(",")) {
            if (pattern.startsWith("--")) continue;
            if (pattern.startsWith("-header:")) {
                pattern = StringHelper.after((String)pattern, (String)"-header:");
            }
            if (!PatternHelper.matchPattern((String)key, (String)pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean isBodyEnabled() {
        String[] parts = this.filter.split(",");
        boolean onlyExclude = true;
        for (String pattern : parts) {
            if (pattern.startsWith("--")) continue;
            if ("body".equals(pattern) || "+body".equals(pattern)) {
                return true;
            }
            if ("-body".equals(pattern)) {
                return false;
            }
            onlyExclude &= pattern.startsWith("-");
        }
        return onlyExclude;
    }

    private boolean isHeadersEnabled() {
        String[] parts = this.filter.split(",");
        boolean onlyExclude = true;
        for (String pattern : parts) {
            if (pattern.startsWith("--")) continue;
            if (pattern.startsWith("header:") || pattern.startsWith("+header:") || pattern.startsWith("-header:")) {
                return false;
            }
            if ("headers".equals(pattern) || "+headers".equals(pattern)) {
                return true;
            }
            if ("-headers".equals(pattern)) {
                return false;
            }
            onlyExclude &= pattern.startsWith("-");
        }
        return onlyExclude;
    }
}

