/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

public class AuthenticateResult {
    private final Type type;
    private long retryAfter = 0L;

    public static AuthenticateResult authorized() {
        return new AuthenticateResult(Type.AUTHORIZED);
    }

    public static AuthenticateResult notAuthorized() {
        return new AuthenticateResult(Type.NOT_AUTHORIZED);
    }

    public static AuthenticateResult noCredentials() {
        return new AuthenticateResult(Type.NO_CREDENTIALS);
    }

    public static AuthenticateResult throttled(long retryAfter) {
        return new AuthenticateResult(Type.THROTTLED, retryAfter);
    }

    private AuthenticateResult(Type type) {
        this.type = type;
    }

    private AuthenticateResult(Type type, long retryAfter) {
        this.type = type;
        this.retryAfter = retryAfter;
    }

    public boolean is(Type type) {
        return this.type == type;
    }

    public Type getType() {
        return this.type;
    }

    public long getRetryAfter() {
        return this.retryAfter;
    }

    public static enum Type {
        AUTHORIZED,
        NOT_AUTHORIZED,
        NO_CREDENTIALS,
        THROTTLED;

    }
}

