/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.hawt.system.AuthHelpers;
import io.hawt.system.JmxHelpers;
import java.lang.management.ManagementFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBACMBeanInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(RBACMBeanInvoker.class);
    private static final long CAN_INVOKE_CACHE_DURATION = 10L;
    private static final long MBEAN_INFO_CACHE_DURATION = 10L;
    protected MBeanServer mBeanServer;
    protected ObjectName securityMBean;
    protected LoadingCache<CanInvokeKey, Boolean> canInvokeCache;
    protected LoadingCache<ObjectName, Map<String, MBeanAttributeInfo>> mbeanInfoCache;

    public RBACMBeanInvoker() {
        this.initSecurityMBean();
        this.initCaches();
    }

    protected void initSecurityMBean() {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        HashSet<ObjectName> mbeans = new HashSet();
        try {
            mbeans = this.mBeanServer.queryNames(new ObjectName("*:type=security,area=jmx,*"), null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found JMXSecurity MBeans: {}", mbeans);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (mbeans.isEmpty()) {
            LOG.info("Didn't discover any JMXSecurity MBeans, role based access control is disabled");
            this.securityMBean = null;
            return;
        }
        ObjectName chosen = JmxHelpers.chooseMBean(mbeans);
        LOG.info("Using MBean [{}] for role based access control", (Object)chosen);
        this.securityMBean = chosen;
    }

    protected void initCaches() {
        this.canInvokeCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build(key -> {
            LOG.debug("Do invoking canInvoke() for {}", key);
            return this.doCanInvoke(key.objectName, key.operation);
        });
        this.mbeanInfoCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build(objectName -> {
            LOG.debug("Do loading MBean attributes for {}", objectName);
            return this.loadMBeanAttributes((ObjectName)objectName);
        });
    }

    protected boolean doCanInvoke(ObjectName objectName, String operation) throws Exception {
        ArrayList<String> argTypes = new ArrayList<String>();
        String opName = this.parseOperation(operation, argTypes);
        Object[] params = new Object[]{objectName.toString(), opName, argTypes.toArray(new String[0])};
        String[] signature = new String[]{String.class.getName(), String.class.getName(), String[].class.getName()};
        return (Boolean)this.mBeanServer.invoke(this.securityMBean, "canInvoke", params, signature);
    }

    private String parseOperation(String operation, List<String> argTypes) {
        int index = (operation = operation.trim()).indexOf(40);
        if (index < 0) {
            return operation;
        }
        String args = operation.substring(index + 1, operation.length() - 1);
        for (String arg : args.split(",")) {
            if ("".equals(arg)) continue;
            argTypes.add(arg);
        }
        return operation.substring(0, index);
    }

    private static void logMBeanError(Exception e) {
        if (e instanceof InstanceNotFoundException) {
            LOG.info("Instance not found: {}", (Object)e.getMessage());
        } else if (e.getCause() instanceof InstanceNotFoundException) {
            LOG.info("Instance not found: {}", (Object)e.getCause().getMessage());
        } else {
            LOG.error("Error while invoking JMXSecurity MBean: " + e.getMessage(), (Throwable)e);
        }
    }

    protected Map<String, MBeanAttributeInfo> loadMBeanAttributes(ObjectName objectName) throws Exception {
        MBeanInfo mBeanInfo = this.mBeanServer.getMBeanInfo(objectName);
        HashMap<String, MBeanAttributeInfo> answer = new HashMap<String, MBeanAttributeInfo>();
        for (MBeanAttributeInfo info : mBeanInfo.getAttributes()) {
            answer.put(info.getName(), info);
        }
        return answer;
    }

    public boolean canInvoke(ObjectName objectName, String operation) {
        if (this.securityMBean == null) {
            return true;
        }
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        try {
            if (subject != null) {
                String username = AuthHelpers.getUsername(subject);
                return (Boolean)this.canInvokeCache.get((Object)new CanInvokeKey(username, objectName, operation));
            }
            LOG.debug("Subject not available, directly invoking canInvoke(): {}, {}", (Object)objectName, (Object)operation);
            return this.doCanInvoke(objectName, operation);
        }
        catch (Exception e) {
            RBACMBeanInvoker.logMBeanError(e);
            return false;
        }
    }

    public boolean isReadAllowed(ObjectName objectName, String attribute) {
        if (this.securityMBean == null) {
            return true;
        }
        try {
            MBeanAttributeInfo info = (MBeanAttributeInfo)((Map)this.mbeanInfoCache.get((Object)objectName)).get(attribute);
            if (info == null) {
                LOG.error("Attribute '{}' not found for MBean '{}'", (Object)attribute, (Object)objectName);
                return false;
            }
            return this.canInvoke(objectName, this.getAccessor(info, false));
        }
        catch (Exception e) {
            RBACMBeanInvoker.logMBeanError(e);
            return false;
        }
    }

    public boolean isWriteAllowed(ObjectName objectName, String attribute) {
        if (this.securityMBean == null) {
            return true;
        }
        try {
            MBeanAttributeInfo info = (MBeanAttributeInfo)((Map)this.mbeanInfoCache.get((Object)objectName)).get(attribute);
            if (info == null) {
                LOG.error("Attribute '{}' not found for MBean '{}'", (Object)attribute, (Object)objectName);
                return false;
            }
            return this.canInvoke(objectName, this.getAccessor(info, true));
        }
        catch (Exception e) {
            RBACMBeanInvoker.logMBeanError(e);
            return false;
        }
    }

    private String getAccessor(MBeanAttributeInfo attribute, boolean write) {
        if (write) {
            return String.format("set%s(%s)", attribute.getName(), attribute.getType());
        }
        return String.format("%s%s()", attribute.isIs() ? "is" : "get", attribute.getName());
    }

    protected static class CanInvokeKey {
        protected String username;
        protected ObjectName objectName;
        protected String operation;

        protected CanInvokeKey(String username, ObjectName objectName, String operation) {
            this.username = username;
            this.objectName = objectName;
            this.operation = operation;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CanInvokeKey)) {
                return false;
            }
            CanInvokeKey key = (CanInvokeKey)obj;
            return Objects.equals(this.username, key.username) && Objects.equals(this.objectName, key.objectName) && Objects.equals(this.operation, key.operation);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.objectName, this.operation);
        }

        public String toString() {
            return String.format("%s{username=%s, objectName=%s, operation=%s}", this.getClass().getSimpleName(), this.username, this.objectName, this.operation);
        }
    }
}

