/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.nodes.EffectiveMergedOutputElements;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.ImportSchemaOrModule;
import com.ibm.xtq.ast.nodes.Include;
import com.ibm.xtq.ast.nodes.NamespaceAlias;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.Output;
import com.ibm.xtq.ast.nodes.Template;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.parsers.xpath.tempconstructors.INSBinding;
import com.ibm.xtq.ast.parsers.xpath.tempconstructors.IOptionDecl;
import com.ibm.xtq.ast.parsers.xpath.tempconstructors.ISetter;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.common.utils.SystemIDResolver;
import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.scontext.XStaticContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class XTQProgram
extends Expr {
    private String _moduleNamespaceNCName;
    private String _moduleNamespaceURILiteral;
    private String _systemId;
    private String _origSystemId;
    private String _publicId;
    private XTQProgram _parentXTQProgram;
    private Boolean _hasLocalParams = null;
    private Boolean _hasTunnelParams = null;
    private String _className;
    private final List _templates = new ArrayList();
    private final Hashtable _options = new Hashtable();
    public XTQProgram _importedFrom = null;
    public XTQProgram _includedFrom = null;
    private List _includedXTQPrograms = null;
    private List _importedXTQPrograms = null;
    private int _importPrecedence = 1;
    public static final int UNKNOWN_PRECEDENCE = -1;
    public List _schemaImports;
    public List _moduleImports;
    public boolean _preserveInputTypeAnnotations = false;
    private int _minimumDescendantPrecedence = -1;
    private boolean _callsNodeset = false;
    private Hashtable _keys = new Hashtable();
    private boolean _numberFormattingUsed = false;
    private boolean _simplified = false;
    private SourceLoader _loader = null;
    private boolean _templateInlining = true;
    private boolean _forwardReference = false;
    private boolean _hasIdCall = false;
    private Output _lastOutputElement = null;
    private Properties _outputProperties = null;
    private XStaticContext _context = null;
    private XSLTParser _parser;
    public static final int UNKNOWN_OUTPUT = 0;
    public static final int XML_OUTPUT = 1;
    public static final int HTML_OUTPUT = 2;
    public static final int TEXT_OUTPUT = 3;
    public static final int XHTML_OUTPUT = 4;
    private int _outputMethod = 0;
    protected int _defaultValidation = 1;
    public EffectiveMergedOutputElements m_mergedOutputElems = null;

    public XTQProgram(int n) {
        super(3);
        this.id = n;
    }

    public XTQProgram() {
        super(3);
    }

    public XTQProgram(XStaticContext xStaticContext) {
        super(3);
        this._context = xStaticContext;
    }

    public Hashtable getKeys() {
        return this._keys;
    }

    public List getIncludedStylesheets() {
        return this._includedXTQPrograms;
    }

    public List getImportedStylesheets() {
        return this._importedXTQPrograms;
    }

    public boolean hasIdCall() {
        return this._hasIdCall;
    }

    public int getOutputMethod() {
        return this._outputMethod;
    }

    public void checkOutputMethod() {
        String string;
        if (this._lastOutputElement != null && (string = this._lastOutputElement.getOutputMethod()) != null) {
            if (string.equals("xml")) {
                this._outputMethod = 1;
            } else if (string.equals("html")) {
                this._outputMethod = 2;
            } else if (string.equals("text")) {
                this._outputMethod = 3;
            } else if (string.equals("xhtml")) {
                this._outputMethod = 4;
            }
        }
    }

    public void setForwardReference() {
        this._forwardReference = true;
    }

    public boolean getTemplateInlining() {
        return this._templateInlining;
    }

    public void setTemplateInlining(boolean bl) {
        this._templateInlining = bl;
    }

    public boolean isSimplified() {
        return this._simplified;
    }

    public void setSimplified() {
        this._simplified = true;
    }

    public void setHasIdCall(boolean bl) {
        this._hasIdCall = bl;
    }

    public void setOutputProperty(String string, String string2) {
        if (this._outputProperties == null) {
            this._outputProperties = new Properties();
        }
        this._outputProperties.setProperty(string, string2);
    }

    public void setOutputProperties(Properties properties) {
        this._outputProperties = properties;
    }

    public Properties getOutputProperties() {
        return this._outputProperties;
    }

    public Output getLastOutputElement() {
        return this._lastOutputElement;
    }

    public void setLastOutputElement(Output output) {
        this._lastOutputElement = output;
    }

    public void setCallsNodeset(boolean bl) {
        this._callsNodeset = bl;
    }

    public boolean callsNodeset() {
        return this._callsNodeset;
    }

    public void setNumberFormattingUsed(boolean bl) {
        this._numberFormattingUsed = bl;
    }

    public boolean isNumberFormattingUsed() {
        return this._numberFormattingUsed;
    }

    public void setImportPrecedence(int n) {
        this._importPrecedence = n;
        int n2 = this.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            XTQProgram xTQProgram;
            Expr expr = (Expr)this.jjtGetChild(i);
            if (!(expr instanceof Include) || (xTQProgram = ((Include)expr).getIncluded()) == null || xTQProgram._includedFrom != this) continue;
            xTQProgram.setImportPrecedence(n);
        }
        if (this._importedFrom != null) {
            if (this._importedFrom.getImportPrecedence() < n) {
                XSLTParser xSLTParser = this._parser;
                int n3 = xSLTParser.getNextImportPrecedence();
                this._importedFrom.setImportPrecedence(n3);
            }
        } else if (this._includedFrom != null && this._includedFrom.getImportPrecedence() != n) {
            this._includedFrom.setImportPrecedence(n);
        }
    }

    @Override
    public int getImportPrecedence() {
        return this._importPrecedence;
    }

    public int getMinimumDescendantPrecedence() {
        if (this._minimumDescendantPrecedence == -1) {
            int n = this.getImportPrecedence();
            int n2 = this._includedXTQPrograms != null ? this._includedXTQPrograms.size() : 0;
            for (int i = 0; i < n2; ++i) {
                int n3 = ((XTQProgram)this._includedXTQPrograms.get(i)).getMinimumDescendantPrecedence();
                if (n3 >= n) continue;
                n = n3;
            }
            this._minimumDescendantPrecedence = n;
        }
        return this._minimumDescendantPrecedence;
    }

    public Set getAllImportedStylesheet(Set set) {
        if (this._importedXTQPrograms == null || this._importedXTQPrograms.size() == 0) {
            return set;
        }
        for (XTQProgram xTQProgram : this._importedXTQPrograms) {
            xTQProgram.getAllImportedStylesheet(set);
            set.add(xTQProgram);
        }
        return set;
    }

    public boolean checkForLoop(String string) {
        if (this._systemId != null && this._systemId.equals(string)) {
            return true;
        }
        if (this._parentXTQProgram != null) {
            return this._parentXTQProgram.checkForLoop(string);
        }
        return false;
    }

    public void setParser(XSLTParser xSLTParser) {
        this._parser = xSLTParser;
        this._context = xSLTParser.getStaticContext();
    }

    public void setParentXTQProgram(XTQProgram xTQProgram) {
        this._parentXTQProgram = xTQProgram;
    }

    public XTQProgram getParentXTQProgram() {
        return this._parentXTQProgram;
    }

    public void setImportingStylesheet(XTQProgram xTQProgram) {
        this._importedFrom = xTQProgram;
        xTQProgram.addIncludedXTQProgram(this);
        xTQProgram.addImportedXTQProgram(this);
    }

    public void setIncludingStylesheet(XTQProgram xTQProgram) {
        this._includedFrom = xTQProgram;
        xTQProgram.addIncludedXTQProgram(this);
    }

    public void addIncludedXTQProgram(XTQProgram xTQProgram) {
        if (this._includedXTQPrograms == null) {
            this._includedXTQPrograms = new ArrayList();
        }
        this._includedXTQPrograms.add(xTQProgram);
    }

    public void addImportedXTQProgram(XTQProgram xTQProgram) {
        if (this._importedXTQPrograms == null) {
            this._importedXTQPrograms = new ArrayList();
        }
        this._importedXTQPrograms.add(xTQProgram);
    }

    public void setSystemId(String string) {
        if (string == null) {
            string = "";
        }
        this._systemId = SystemIDResolver.getAbsoluteURI(string);
        String string2 = (String)this.getProperty(_BASEURI_KEY);
        if (string2 == null) {
            this.setBaseURI(this._systemId);
        } else if (!SystemIDResolver.isAbsolutePath(string2) && !SystemIDResolver.isAbsoluteURI(string2)) {
            try {
                this.setBaseURI(SystemIDResolver.getAbsoluteURI(string2, this._systemId));
            }
            catch (TransformerException transformerException) {
                throw new WrappedRuntimeException(transformerException);
            }
        }
    }

    public void setPublicId(String string) {
        this._publicId = string;
    }

    public void setSourceLoader(SourceLoader sourceLoader) {
        this._loader = sourceLoader;
    }

    public SourceLoader getSourceLoader() {
        return this._loader;
    }

    public boolean hasLocalParams() {
        if (this._hasLocalParams == null) {
            List list = this.getAllValidTemplates();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Template template = (Template)list.get(i);
                if (!template.hasNonTunnelParams() && !template.hasTunnelParams()) continue;
                this._hasLocalParams = Boolean.TRUE;
                return true;
            }
            this._hasLocalParams = Boolean.FALSE;
            return false;
        }
        return this._hasLocalParams;
    }

    public boolean hasTunnelParams() {
        if (this._hasTunnelParams == null) {
            List list = this.getAllValidTemplates();
            int n = list.size();
            Vector vector = this._context.getAllTunnelParamNames();
            if (vector != null && vector.size() > 0) {
                this._hasTunnelParams = new Boolean(true);
                return true;
            }
            this._hasTunnelParams = new Boolean(false);
            return false;
        }
        return this._hasTunnelParams;
    }

    @Override
    public void addPrefixMapping(String string, String string2) {
        if (string.equals("") && string2.equals("http://www.w3.org/1999/xhtml")) {
            return;
        }
        super.addPrefixMapping(string, string2);
    }

    @Override
    public void parseContents(XSLTParser xSLTParser) {
        Object object;
        this.addPrefixMapping("xml", "http://www.w3.org/XML/1998/namespace");
        String string = this.getProgramVersion();
        double d = Double.parseDouble(string);
        if (this._simplified) {
            this.excludeURI("http://www.w3.org/1999/XSL/Transform");
            object = new Template(this.getProgramVersion());
            if (d > 1.0) {
                this.setPreserveInputTypeAnnotations(true);
            }
            ((Template)object).parseSimplified(this, xSLTParser);
        } else {
            if (this.getAttribute("input-type-annotations").equals("strip") || d < 2.0) {
                this.setPreserveInputTypeAnnotations(false);
            } else {
                this.setPreserveInputTypeAnnotations(true);
            }
            this.parseOwnChildren(xSLTParser);
        }
        if (this.hasAttribute("default-validation")) {
            object = this.getAttribute("default-validation");
            String string2 = "xsl:stylesheet";
            xSLTParser.checkAttributeValue(this, string2, "default-validation", (String)object, 3);
            this.setDefaultValidation((String)object);
        }
    }

    public final void parseOwnChildren(XSLTParser xSLTParser) {
        Expr expr;
        int n;
        xSLTParser.checkAllowedChildren(this);
        int n2 = this.jjtGetNumChildren();
        for (n = 0; n < n2; ++n) {
            expr = (Expr)this.jjtGetChild(n);
            if (!(expr instanceof VariableBase) && !(expr instanceof NamespaceAlias)) continue;
            xSLTParser.getStaticContext().setCurrentNode(expr);
            expr.callParseContents(xSLTParser);
        }
        for (n = 0; n < n2; ++n) {
            expr = (Expr)this.jjtGetChild(n);
            if (!(expr instanceof VariableBase) && !(expr instanceof NamespaceAlias)) {
                xSLTParser.getStaticContext().setCurrentNode(expr);
                expr.callParseContents(xSLTParser);
            }
            if (this._templateInlining || !(expr instanceof Template)) continue;
            Template template = (Template)expr;
            String string = "template$dot$" + template.getPosition();
            template.setQName(xSLTParser.getQName(string));
        }
    }

    @Override
    public String toString() {
        return "Program class=" + this.getClass();
    }

    public String getNamespace(String string) {
        return this.lookupNamespace(string);
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String string) {
        this._className = string;
    }

    public List getTemplates() {
        return this._templates;
    }

    public List getAllValidTemplates() {
        if (this._includedXTQPrograms != null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this._templates);
            int n = this._includedXTQPrograms.size();
            for (int i = 0; i < n; ++i) {
                XTQProgram xTQProgram = (XTQProgram)this._includedXTQPrograms.get(i);
                arrayList.addAll(xTQProgram.getAllValidTemplates());
            }
            return arrayList;
        }
        return this._templates;
    }

    protected void addTemplate(Template template) {
        this._templates.add(template);
    }

    public XTQProgram getTopLevelXTQProgram() {
        XTQProgram xTQProgram = this;
        boolean bl = false;
        while (!bl) {
            if (xTQProgram._includedFrom != null) {
                xTQProgram = xTQProgram._includedFrom;
                continue;
            }
            if (xTQProgram._importedFrom != null) {
                xTQProgram = xTQProgram._importedFrom;
                continue;
            }
            bl = true;
        }
        return xTQProgram;
    }

    public void updateEffectiveMergedXslOutputElement(int n, String string, String string2, String string3) {
        this.updateMergedOutputElement(n, string, string2, string3);
    }

    private void updateMergedOutputElement(int n, String string, String string2, String string3) {
        XTQProgram xTQProgram = this.getTopLevelXTQProgram();
        if (xTQProgram.m_mergedOutputElems == null) {
            xTQProgram.m_mergedOutputElems = new EffectiveMergedOutputElements();
        }
        xTQProgram.m_mergedOutputElems.updateEffectiveMergedXSLOutputElement(n, string, string2, string3);
    }

    public Properties getEffectiveMergedXslOutputProperties(String string) {
        XTQProgram xTQProgram = this.getTopLevelXTQProgram();
        return xTQProgram.m_mergedOutputElems.getEffectiveMergedXslOutputProperties(string);
    }

    public String[] getEffectiveMergedOutputNames() {
        XTQProgram xTQProgram = this.getTopLevelXTQProgram();
        return xTQProgram.m_mergedOutputElems.getOutputNames();
    }

    public EffectiveMergedOutputElements getMergedOutputElements() {
        XTQProgram xTQProgram = this.getTopLevelXTQProgram();
        return xTQProgram.m_mergedOutputElems;
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string) {
        HashMap hashMap;
        String string2 = this._context.getDefaultCollationName();
        if (string2 != null) {
            stringBuffer.append("declare default collation '");
            stringBuffer.append(string2);
            stringBuffer.append("';\n");
        }
        if ((hashMap = this.getPrefixMapping()) != null) {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string3 = (String)entry.getValue();
                String string4 = (String)entry.getKey();
                if (string4.equals("")) {
                    stringBuffer.append("declare default namespace '");
                } else {
                    stringBuffer.append("declare namespace ");
                    stringBuffer.append(string4);
                    stringBuffer.append("=");
                }
                stringBuffer.append('\"');
                stringBuffer.append(string3);
                stringBuffer.append('\"');
                stringBuffer.append(";\n");
            }
        }
        this.getXQueryStringForChildren(stringBuffer, bl, string);
    }

    @Override
    public void jjtAddChild(ASTBuildingContext aSTBuildingContext, Node node, int n) {
        if (node instanceof ISetter) {
            if (15 == node.getId()) {
                this.setDefaultElementTypeNamespace(aSTBuildingContext.getStaticContext().getDefaultNamespaceForElementType());
            }
            return;
        }
        switch (node.getId()) {
            case 26: {
                this.addSchemaImport((ImportSchemaOrModule)node);
                break;
            }
            case 28: {
                this.addModuleImport((ImportSchemaOrModule)node);
                break;
            }
            case 8: {
                INSBinding iNSBinding = (INSBinding)node;
                this.setModuleNamespaceNCName(iNSBinding.getNcname());
                this.setModuleNamespaceURILiteral(iNSBinding.getURILiteral());
                break;
            }
            case 13: {
                INSBinding iNSBinding = (INSBinding)node;
                this.addPrefixMapping(iNSBinding.getNcname(), iNSBinding.getURILiteral());
                break;
            }
            case 16: {
                IOptionDecl iOptionDecl = (IOptionDecl)node;
                this._options.put(iOptionDecl.getQName(), iOptionDecl.getValue());
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 39: {
                this.addChildrenOfUselessNode(aSTBuildingContext, node, 0);
                break;
            }
            case 12: {
                break;
            }
            default: {
                super.jjtInsertChild(node, n);
            }
        }
    }

    @Override
    public void jjtClose(ASTBuildingContext aSTBuildingContext) {
        super.jjtClose(aSTBuildingContext);
        this.removeNullChildren();
    }

    @Override
    public void jjtOpen(ASTBuildingContext aSTBuildingContext) {
        super.jjtOpen(aSTBuildingContext);
    }

    public String getModuleNamespaceNCName() {
        return this._moduleNamespaceNCName;
    }

    public void setModuleNamespaceNCName(String string) {
        this._moduleNamespaceNCName = string;
    }

    public String getModuleNamespaceURILiteral() {
        return this._moduleNamespaceURILiteral;
    }

    public void setModuleNamespaceURILiteral(String string) {
        this._moduleNamespaceURILiteral = string;
    }

    public List getModuleImports() {
        return this._moduleImports;
    }

    public void addModuleImport(ImportSchemaOrModule importSchemaOrModule) {
        if (null == this._moduleImports) {
            this._moduleImports = new ArrayList();
        }
        this._moduleImports.add(importSchemaOrModule);
    }

    public List getSchemaImports() {
        return this._schemaImports;
    }

    public void addSchemaImport(ImportSchemaOrModule importSchemaOrModule) {
        if (null == this._schemaImports) {
            this._schemaImports = new ArrayList();
        }
        this._schemaImports.add(importSchemaOrModule);
    }

    @Override
    public void setProgramVersion(String string) {
        super.setProgramVersion(string);
        double d = Double.valueOf(this.getProgramVersion());
        if (d < 2.0) {
            this._parser.getExpressionFactory().setLanguage("XPath1");
        } else {
            this._parser.getExpressionFactory().setLanguage("XPath2");
        }
    }

    public boolean isPreserveInputTypeAnnotations() {
        return this._preserveInputTypeAnnotations;
    }

    public void setPreserveInputTypeAnnotations(boolean bl) {
        this._preserveInputTypeAnnotations = bl;
    }

    protected void setDefaultValidation(String string) {
        if (string.equals("preserve")) {
            this._defaultValidation = 2;
        } else if (string.equals("strip")) {
            this._defaultValidation = 1;
        }
    }

    protected int getDefaultValidation() {
        return this._defaultValidation;
    }

    public XStaticContext getStaticContext() {
        return this._context;
    }
}

