/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class FunctionInstantiation
implements Serializable {
    private static final long serialVersionUID = -209181267043783730L;
    public Type m_returnType;
    public Type[] m_parameterTypes;
    public Function m_function;
    public Map m_templateToInstantiation;
    public TypeEnvironment m_targetTypeEnvironment;
    public Type[] m_resolvedParameterTypes;
    public BindingEnvironment m_targetBindingEnvironment;
    FunctionInstantiation m_original;
    protected FunctionCallInstruction m_fci;
    public static final boolean s_enableProfiling = false;
    private static final HashMap s_profileData = new HashMap();

    public static void profileHit(String string) {
        Integer n = (Integer)s_profileData.get(string);
        int n2 = n == null ? 0 : n;
        s_profileData.put(string, new Integer(n2 + 1));
    }

    public FunctionInstantiation(Function function, Type[] typeArray, Type type, Map map, TypeEnvironment typeEnvironment, FunctionCallInstruction functionCallInstruction, BindingEnvironment bindingEnvironment) {
        this.m_function = function;
        this.m_parameterTypes = typeArray;
        this.m_returnType = type;
        this.m_templateToInstantiation = map;
        this.m_targetTypeEnvironment = typeEnvironment;
        this.m_original = this;
        this.m_fci = functionCallInstruction;
        this.m_targetBindingEnvironment = bindingEnvironment;
    }

    public FunctionInstantiation(FunctionInstantiation functionInstantiation) {
        this.m_function = functionInstantiation.m_function;
        this.m_returnType = functionInstantiation.m_returnType;
        this.m_parameterTypes = functionInstantiation.m_parameterTypes;
        this.m_original = functionInstantiation;
        this.m_resolvedParameterTypes = new Type[functionInstantiation.m_parameterTypes.length];
        for (int i = 0; i < functionInstantiation.m_parameterTypes.length; ++i) {
            Type type = functionInstantiation.m_parameterTypes[i].resolveType(functionInstantiation.m_targetTypeEnvironment);
            if (type == null) {
                throw new RuntimeException();
            }
            this.m_resolvedParameterTypes[i] = type;
        }
    }

    public int hashCode() {
        return this.m_parameterTypes.length + this.m_function.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (this.m_resolvedParameterTypes == null) {
            return this == object;
        }
        if (object == null || !(object instanceof FunctionInstantiation)) {
            return false;
        }
        FunctionInstantiation functionInstantiation = (FunctionInstantiation)object;
        if (functionInstantiation.m_function != this.m_function) {
            return false;
        }
        return this.toString().equals(functionInstantiation.toString());
    }

    public void doFinalTypeCheck() throws TypeCheckException {
        this.makeTypeEnvironment();
    }

    protected TypeEnvironment makeTypeEnvironment() throws TypeCheckException {
        Type type;
        TypeEnvironment typeEnvironment = (TypeEnvironment)this.m_function.getTypeEnvironment().clone();
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            type = this.m_parameterTypes[i];
            this.m_function.unifyParameter(typeEnvironment, this.m_targetBindingEnvironment, type, this.m_fci.m_parameters, i, this.m_fci, true);
        }
        if (this.m_templateToInstantiation != null) {
            Type type2 = this.m_function.getReturnType().duplicateType(this.m_templateToInstantiation);
            type = this.m_function.getReturnType().resolveType(typeEnvironment);
            if (type != null) {
                this.m_targetTypeEnvironment.unify(type, type2, null);
            }
        }
        return typeEnvironment;
    }

    public void generateParamSpecs(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, StringBuffer stringBuffer, CodeGenerationTracker codeGenerationTracker) {
        FunctionInstantiation.generateParamSpecs(dataFlowCodeGenerationHelper, stringBuffer, codeGenerationTracker, this.m_resolvedParameterTypes, this.m_function.m_parameters);
    }

    public static final void generateParamSpecs(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, StringBuffer stringBuffer, CodeGenerationTracker codeGenerationTracker, Type[] typeArray, IBinding[] iBindingArray) {
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            if (iBindingArray[i] != null) {
                stringArray[i] = dataFlowCodeGenerationHelper.generateNewLocalVariableName(Binding.generateVariableName(iBindingArray[i], dataFlowCodeGenerationHelper));
                codeGenerationTracker.registerExtantBinding(iBindingArray[i], stringArray[i]);
            } else {
                stringArray[i] = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
            }
            Type type = typeArray[i];
            type.generateParamSpec(stringBuffer, dataFlowCodeGenerationHelper, stringArray[i], codeGenerationTracker.getCurrentModule());
            if (i == typeArray.length - 1) continue;
            stringBuffer.append(", ");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_function.getName());
        stringBuffer.append('(');
        for (int i = 0; i < this.m_resolvedParameterTypes.length; ++i) {
            stringBuffer.append(this.m_resolvedParameterTypes[i]);
            if (i == this.m_resolvedParameterTypes.length - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

