/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DiskChecker;

public interface FSDatasetInterface
extends FSDatasetMBean {
    public long getMetaDataLength(Block var1) throws IOException;

    public MetaDataInputStream getMetaDataInputStream(Block var1) throws IOException;

    public boolean metaFileExists(Block var1) throws IOException;

    public long getLength(Block var1) throws IOException;

    public long getVisibleLength(Block var1) throws IOException;

    public void setVisibleLength(Block var1, long var2) throws IOException;

    public Block getStoredBlock(long var1) throws IOException;

    public InputStream getBlockInputStream(Block var1) throws IOException;

    public InputStream getBlockInputStream(Block var1, long var2) throws IOException;

    public BlockInputStreams getTmpInputStreams(Block var1, long var2, long var4) throws IOException;

    public BlockWriteStreams writeToBlock(Block var1, boolean var2, boolean var3) throws IOException;

    public void updateBlock(Block var1, Block var2) throws IOException;

    public void finalizeBlock(Block var1) throws IOException;

    public void finalizeBlockIfNeeded(Block var1) throws IOException;

    public void unfinalizeBlock(Block var1) throws IOException;

    public Block[] getBlockReport();

    public void requestAsyncBlockReport();

    public boolean isAsyncBlockReportReady();

    public Block[] retrieveAsyncBlockReport();

    public Block[] getBlocksBeingWrittenReport();

    public boolean isValidBlock(Block var1);

    public void invalidate(Block[] var1) throws IOException;

    public void checkDataDir() throws DiskChecker.DiskErrorException;

    public String toString();

    public void shutdown();

    public long getChannelPosition(Block var1, BlockWriteStreams var2) throws IOException;

    public void setChannelPosition(Block var1, BlockWriteStreams var2, long var3, long var5) throws IOException;

    public void validateBlockMetadata(Block var1) throws IOException;

    public boolean hasEnoughResource();

    public BlockRecoveryInfo startBlockRecovery(long var1) throws IOException;

    public BlockLocalPathInfo getBlockLocalPathInfo(Block var1) throws IOException;

    public static class BlockInputStreams
    implements Closeable {
        final InputStream dataIn;
        final InputStream checksumIn;

        BlockInputStreams(InputStream dataIn, InputStream checksumIn) {
            this.dataIn = dataIn;
            this.checksumIn = checksumIn;
        }

        @Override
        public void close() {
            IOUtils.closeStream(this.dataIn);
            IOUtils.closeStream(this.checksumIn);
        }
    }

    public static class BlockWriteStreams {
        OutputStream dataOut;
        OutputStream checksumOut;

        BlockWriteStreams(OutputStream dOut, OutputStream cOut) {
            this.dataOut = dOut;
            this.checksumOut = cOut;
        }
    }

    public static class MetaDataInputStream
    extends FilterInputStream {
        private long length;

        MetaDataInputStream(InputStream stream, long len) {
            super(stream);
            this.length = len;
        }

        public long getLength() {
            return this.length;
        }
    }
}

