/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xylem.JavaClassImporter;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.Type;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.types.JavaClassInformation;
import com.ibm.xylem.types.ObjectFactory;
import com.ibm.xylem.utils.XylemError;
import java.util.HashMap;
import java.util.Map;

public class JavaObjectType
extends Type {
    private static final long serialVersionUID = -5224774453403727058L;
    public static final JavaObjectType s_javaStringType = new JavaObjectType("java.lang.String");
    public static final JavaObjectType s_javaHashMapType = new JavaObjectType("java.util.HashMap");
    static Logger s_logger = Logger.getInstance(JavaObjectType.class);
    protected String m_className;
    private static HashMap s_primitiveMap = new HashMap();

    public JavaObjectType() {
    }

    @Override
    public Type expandTypeAliases(Module module) {
        return this;
    }

    public String getClassName() {
        return this.m_className;
    }

    public JavaObjectType(String string) {
        this.m_className = string;
    }

    public String toString() {
        return this.m_className;
    }

    @Override
    public com.ibm.xtq.bcel.generic.Type getImplementationType(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        return new ObjectType(this.getJavaType().getName());
    }

    @Override
    public Class getJavaType() {
        String string = this.getClassName();
        Class clazz = (Class)s_primitiveMap.get(string);
        while (clazz == null) {
            try {
                clazz = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    string = string.substring(0, n) + "$" + string.substring(n + 1, string.length());
                    continue;
                }
                throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.getClassName());
            }
        }
        return clazz;
    }

    public boolean equals(Object object) {
        return object instanceof JavaObjectType && this.m_className.equals(((JavaObjectType)object).m_className);
    }

    public int hashCode() {
        return this.m_className.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        return this;
    }

    public JavaClassInformation getInformation(Module module) {
        try {
            return JavaClassImporter.retrieveJavaClassInformation(this.m_className, module);
        }
        catch (Exception exception) {
            s_logger.warn("class " + this.m_className + " not found on classpath, assuming opaque");
            return new JavaClassInformation();
        }
    }

    @Override
    public String prettyPrint() {
        return "(java " + this.m_className + ")";
    }

    @Override
    public Type duplicateType(Map map) {
        return this;
    }

    @Override
    public String getDefaultValue() {
        return "null";
    }

    static {
        s_primitiveMap.put("boolean", Boolean.TYPE);
        s_primitiveMap.put("byte", Byte.TYPE);
        s_primitiveMap.put("char", Character.TYPE);
        s_primitiveMap.put("short", Short.TYPE);
        s_primitiveMap.put("int", Integer.TYPE);
        s_primitiveMap.put("long", Long.TYPE);
        s_primitiveMap.put("float", Float.TYPE);
        s_primitiveMap.put("double", Double.TYPE);
    }
}

