/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.decoder;

import java.io.EOFException;
import java.io.IOException;
import org.apache.asterix.column.bytes.decoder.AbstractParquetValuesReader;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.bytes.stream.in.ValueInputStream;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.io.ParquetDecodingException;

public class ParquetPlainFixedLengthValuesReader
extends AbstractParquetValuesReader {
    private final ValueInputStream in = new ValueInputStream();
    private final int valueLength;
    private final IPointable valueStorage;

    public ParquetPlainFixedLengthValuesReader(int valueLength) {
        this.valueLength = valueLength;
        this.valueStorage = null;
    }

    public ParquetPlainFixedLengthValuesReader(IPointable valueStorage) {
        this.valueLength = valueStorage.getByteArray().length;
        this.valueStorage = valueStorage;
    }

    @Override
    public void initFromPage(AbstractBytesInputStream stream) throws EOFException {
        this.in.reset(stream.remainingStream());
    }

    @Override
    public void skip() {
        try {
            this.in.skipBytes(this.valueLength);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not skip " + this.valueLength + " bytes", (Throwable)e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.in.readLong();
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read long", (Throwable)e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.in.readFloat();
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read float", (Throwable)e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.in.readDouble();
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read double", (Throwable)e);
        }
    }

    @Override
    public IValueReference readBytes() {
        try {
            return this.in.readBytes(this.valueStorage, this.valueLength);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read bytes", (Throwable)e);
        }
    }
}

