/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.external.input.stream.AsterixInputStreamReader;
import org.apache.asterix.external.input.stream.BasicInputStream;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleInputStream;

public class StandardUTF8ToModifiedUTF8OutputStream
extends OutputStream {
    private static final byte[] EMPTY = new byte[0];
    private final AStringSerializerDeserializer stringSerDer;
    private final ResettableUTF8InputStreamReader reader;
    private final char[] inputBuffer;
    private char[] appendBuffer;
    private DataOutput out;

    public StandardUTF8ToModifiedUTF8OutputStream(AStringSerializerDeserializer stringSerDer) {
        this.stringSerDer = stringSerDer;
        this.reader = new ResettableUTF8InputStreamReader(new ByteArrayAccessibleInputStream(EMPTY, 0, 0));
        this.inputBuffer = new char[ExternalDataConstants.DEFAULT_BUFFER_SIZE];
        this.appendBuffer = new char[ExternalDataConstants.DEFAULT_BUFFER_SIZE];
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.reader.prepareNextRead(b, off, len);
        int numOfChars = this.reader.read(this.inputBuffer);
        int length = 0;
        while (numOfChars > 0) {
            this.appendBuffer = StandardUTF8ToModifiedUTF8OutputStream.append(this.inputBuffer, this.appendBuffer, length, numOfChars);
            length += numOfChars;
            numOfChars = this.reader.read(this.inputBuffer);
        }
        this.stringSerDer.serialize(this.appendBuffer, 0, length, this.out);
    }

    public void setDataOutput(DataOutput out) {
        this.out = out;
    }

    private static char[] append(char[] src, char[] dest, int offset, int length) {
        char[] destBuf = dest;
        if (offset + length > dest.length) {
            char[] newDestBuffer = new char[dest.length * 2];
            System.arraycopy(destBuf, 0, newDestBuffer, 0, offset);
            destBuf = newDestBuffer;
        }
        System.arraycopy(src, 0, destBuf, offset, length);
        return destBuf;
    }

    private static class ResettableUTF8InputStreamReader
    extends AsterixInputStreamReader {
        private final ByteArrayAccessibleInputStream inByte;

        public ResettableUTF8InputStreamReader(ByteArrayAccessibleInputStream inByte) {
            super(new BasicInputStream((InputStream)inByte), ExternalDataConstants.DEFAULT_BUFFER_SIZE);
            this.inByte = inByte;
        }

        public void prepareNextRead(byte[] b, int off, int len) {
            this.inByte.setContent(b, off, len);
            this.done = false;
            this.remaining = false;
            this.byteBuffer.flip();
            this.charBuffer.flip();
        }
    }
}

