/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util.google.gcs;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.BaseServiceException;
import com.google.cloud.NoCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.external.IExternalFilterEvaluator;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.ExceptionUtils;

public class GCSUtils {
    private GCSUtils() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static Storage buildClient(Map<String, String> configuration) throws CompilationException {
        StorageOptions.Builder builder;
        String endpoint;
        block14: {
            String applicationDefaultCredentials = configuration.get("applicationDefaultCredentials");
            String jsonCredentials = configuration.get("jsonCredentials");
            endpoint = configuration.get("endpoint");
            builder = StorageOptions.newBuilder();
            if (applicationDefaultCredentials != null) {
                if (!applicationDefaultCredentials.equalsIgnoreCase("true")) {
                    throw new CompilationException(ErrorCode.INVALID_PARAM_VALUE_ALLOWED_VALUE, new Serializable[]{"applicationDefaultCredentials", "true"});
                }
                if (jsonCredentials != null) {
                    throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{"jsonCredentials", "applicationDefaultCredentials"});
                }
                try {
                    builder.setCredentials((Credentials)GoogleCredentials.getApplicationDefault());
                }
                catch (IOException ex) {
                    throw CompilationException.create((ErrorCode)ErrorCode.EXTERNAL_SOURCE_ERROR, (Serializable[])new Serializable[]{ex, ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
            }
            if (jsonCredentials != null) {
                try (ByteArrayInputStream credentialsStream = new ByteArrayInputStream(jsonCredentials.getBytes());){
                    builder.setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)credentialsStream));
                    break block14;
                }
                catch (IOException ex) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
            }
            builder.setCredentials((Credentials)NoCredentials.getInstance());
        }
        if (endpoint != null) {
            builder.setHost(endpoint);
        }
        return (Storage)builder.build().getService();
    }

    public static void validateProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector) throws CompilationException {
        if (configuration.get("format") == null) {
            throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, srcLoc, new Serializable[]{"format"});
        }
        ExternalDataUtils.validateIncludeExclude(configuration);
        try {
            new ExternalDataPrefix(configuration);
        }
        catch (AlgebricksException ex) {
            throw new CompilationException(ErrorCode.FAILED_TO_CALCULATE_COMPUTED_FIELDS, (Throwable)ex, new Serializable[0]);
        }
        String container = configuration.get("container");
        try {
            Storage.BlobListOption limitOption = Storage.BlobListOption.pageSize((long)1L);
            Storage.BlobListOption prefixOption = Storage.BlobListOption.prefix((String)ExternalDataUtils.getPrefix(configuration));
            Storage storage = GCSUtils.buildClient(configuration);
            Page items = storage.list(container, new Storage.BlobListOption[]{limitOption, prefixOption});
            if (!items.iterateAll().iterator().hasNext() && collector.shouldWarn()) {
                Warning warning = Warning.of((SourceLocation)srcLoc, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                collector.warn(warning);
            }
        }
        catch (CompilationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
    }

    public static List<Blob> listItems(Map<String, String> configuration, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher, IWarningCollector warningCollector, ExternalDataPrefix externalDataPrefix, IExternalFilterEvaluator evaluator) throws CompilationException, HyracksDataException {
        Page items;
        ArrayList<Blob> filesOnly = new ArrayList<Blob>();
        String container = configuration.get("container");
        Storage gcs = GCSUtils.buildClient(configuration);
        Storage.BlobListOption options = Storage.BlobListOption.prefix((String)ExternalDataUtils.getPrefix(configuration));
        try {
            items = gcs.list(container, new Storage.BlobListOption[]{options});
        }
        catch (BaseServiceException ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
        GCSUtils.collectAndFilterFiles((Page<Blob>)items, includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly, externalDataPrefix, evaluator, warningCollector);
        if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
            Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
            warningCollector.warn(warning);
        }
        return filesOnly;
    }

    private static void collectAndFilterFiles(Page<Blob> items, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<Blob> filesOnly, ExternalDataPrefix externalDataPrefix, IExternalFilterEvaluator evaluator, IWarningCollector warningCollector) throws HyracksDataException {
        for (Blob item : items.iterateAll()) {
            if (!ExternalDataUtils.evaluate(item.getName(), predicate, matchers, externalDataPrefix, evaluator, warningCollector)) continue;
            filesOnly.add(item);
        }
    }

    public static void configureHdfsJobConf(JobConf conf, Map<String, String> configuration, int numberOfPartitions) {
        String jsonCredentials = configuration.get("jsonCredentials");
        String endpoint = configuration.get("endpoint");
        HDFSUtils.disableHadoopFileSystemCache((Configuration)conf, "gs");
        conf.set("fs.gs.inputstream.support.gzip.encoding.enable", "false");
        Path credentials = Path.of("credentials.json", new String[0]);
        if (jsonCredentials == null) {
            conf.set("fs.gs.auth.type", "UNAUTHENTICATED");
        } else {
            conf.set("fs.gs.auth.type", "SERVICE_ACCOUNT_JSON_KEYFILE");
            conf.set("google.cloud.auth.service.account.json.keyfile", credentials.toAbsolutePath().toString());
        }
        if (endpoint != null) {
            conf.set("fs.gs.storage.root.url", endpoint);
        }
    }
}

