/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.writer;

import java.io.File;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.writer.ILocalFSValidator;
import org.apache.asterix.external.writer.LocalFSExternalFileWriter;
import org.apache.asterix.runtime.writer.ExternalFileWriterConfiguration;
import org.apache.asterix.runtime.writer.IExternalFileFilterWriterFactoryProvider;
import org.apache.asterix.runtime.writer.IExternalFilePrinterFactory;
import org.apache.asterix.runtime.writer.IExternalFileWriter;
import org.apache.asterix.runtime.writer.IExternalFileWriterFactory;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public final class LocalFSExternalFileWriterFactory
implements IExternalFileWriterFactory {
    private static final long serialVersionUID = 871685327574547749L;
    private static final char SEPARATOR = File.separatorChar;
    public static final IExternalFileFilterWriterFactoryProvider PROVIDER = new IExternalFileFilterWriterFactoryProvider(){

        public IExternalFileWriterFactory create(ExternalFileWriterConfiguration configuration) {
            return new LocalFSExternalFileWriterFactory(configuration);
        }

        public char getSeparator() {
            return SEPARATOR;
        }
    };
    private static final ILocalFSValidator NO_OP_VALIDATOR = LocalFSExternalFileWriterFactory::noOpValidation;
    private static final ILocalFSValidator VALIDATOR = LocalFSExternalFileWriterFactory::validate;
    private final SourceLocation pathSourceLocation;
    private final boolean singleNodeCluster;
    private final String staticPath;
    private boolean validated;

    private LocalFSExternalFileWriterFactory(ExternalFileWriterConfiguration externalConfig) {
        this.pathSourceLocation = externalConfig.getPathSourceLocation();
        this.singleNodeCluster = externalConfig.isSingleNodeCluster();
        this.staticPath = externalConfig.getStaticPath();
        this.validated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExternalFileWriter createWriter(IHyracksTaskContext context, IExternalFilePrinterFactory printerFactory) throws HyracksDataException {
        ILocalFSValidator validator = VALIDATOR;
        if (this.staticPath != null) {
            LocalFSExternalFileWriterFactory localFSExternalFileWriterFactory = this;
            synchronized (localFSExternalFileWriterFactory) {
                this.validateStaticPath();
            }
            validator = NO_OP_VALIDATOR;
        }
        return new LocalFSExternalFileWriter(printerFactory.createPrinter(), validator, this.pathSourceLocation);
    }

    public char getSeparator() {
        return SEPARATOR;
    }

    public void validate() throws AlgebricksException {
        if (this.singleNodeCluster && this.staticPath != null) {
            if (LocalFSExternalFileWriterFactory.isNonEmptyDirectory(new File(this.staticPath))) {
                throw new CompilationException(ErrorCode.DIRECTORY_IS_NOT_EMPTY, this.pathSourceLocation, new Serializable[]{this.staticPath});
            }
            this.validated = true;
        }
    }

    private void validateStaticPath() throws HyracksDataException {
        if (this.validated) {
            return;
        }
        if (LocalFSExternalFileWriterFactory.isNonEmptyDirectory(new File(this.staticPath))) {
            throw new RuntimeDataException(ErrorCode.DIRECTORY_IS_NOT_EMPTY, this.pathSourceLocation, new Serializable[]{this.staticPath});
        }
        this.validated = true;
    }

    static boolean isNonEmptyDirectory(File parentDirectory) {
        if (parentDirectory.exists()) {
            String[] files = parentDirectory.list();
            return files != null && files.length != 0;
        }
        return false;
    }

    private static void noOpValidation(String directory, SourceLocation sourceLocation) {
    }

    private static void validate(String directory, SourceLocation sourceLocation) throws HyracksDataException {
        if (LocalFSExternalFileWriterFactory.isNonEmptyDirectory(new File(directory))) {
            throw new RuntimeDataException(ErrorCode.DIRECTORY_IS_NOT_EMPTY, sourceLocation, new Serializable[]{directory});
        }
    }
}

