/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active.message;

import java.io.Serializable;
import java.util.Objects;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.IActiveNotificationHandler;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;

public class ActivePartitionMessage
implements ICcAddressedMessage {
    private static final long serialVersionUID = 2L;
    private final ActiveRuntimeId activeRuntimeId;
    private final JobId jobId;
    private final Serializable payload;
    private final String desc;
    private final Event event;

    public ActivePartitionMessage(ActiveRuntimeId activeRuntimeId, JobId jobId, Event event, Serializable payload, String desc) {
        this.activeRuntimeId = activeRuntimeId;
        this.jobId = jobId;
        this.event = event;
        this.payload = payload;
        this.desc = desc;
    }

    public ActiveRuntimeId getActiveRuntimeId() {
        return this.activeRuntimeId;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Serializable getPayload() {
        return this.payload;
    }

    public Event getEvent() {
        return this.event;
    }

    public String getDesc() {
        return this.desc;
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        IActiveNotificationHandler activeListener = (IActiveNotificationHandler)appCtx.getActiveNotificationHandler();
        activeListener.receive(this);
    }

    public String toString() {
        return this.activeRuntimeId + ":" + ActivePartitionMessage.class.getSimpleName() + "-" + this.event + "(" + this.desc + ")";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activeRuntimeId, this.jobId, this.payload, this.event});
    }

    public boolean equals(Object o) {
        if (!(o instanceof ActivePartitionMessage)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ActivePartitionMessage other = (ActivePartitionMessage)o;
        return Objects.equals(other.activeRuntimeId, this.activeRuntimeId) && Objects.equals(other.jobId, this.jobId) && Objects.equals(other.payload, this.payload);
    }

    public static enum Event {
        RUNTIME_REGISTERED,
        RUNTIME_DEREGISTERED,
        GENERIC_EVENT;

    }
}

