/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class CompactionPolicy
implements IMetadataEntity<CompactionPolicy> {
    private static final long serialVersionUID = 3L;
    private final String databaseName;
    private final DataverseName dataverseName;
    private final String policyName;
    private final String className;

    public CompactionPolicy(String databaseName, DataverseName dataverseName, String policyName, String className) {
        this.databaseName = Objects.requireNonNull(databaseName);
        this.dataverseName = dataverseName;
        this.policyName = policyName;
        this.className = className;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompactionPolicy)) {
            return false;
        }
        CompactionPolicy otherPolicy = (CompactionPolicy)other;
        if (!Objects.equals(this.databaseName, otherPolicy.databaseName)) {
            return false;
        }
        if (!otherPolicy.dataverseName.equals((Object)this.dataverseName)) {
            return false;
        }
        return otherPolicy.policyName.equals(this.policyName);
    }

    @Override
    public CompactionPolicy addToCache(MetadataCache cache) {
        return cache.addCompactionPolicyIfNotExists(this);
    }

    @Override
    public CompactionPolicy dropFromCache(MetadataCache cache) {
        return cache.dropCompactionPolicy(this);
    }
}

