/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class BlockReportOptions {
    private final boolean incremental;
    private final InetSocketAddress namenodeAddr;

    private BlockReportOptions(boolean incremental, InetSocketAddress namenodeAddr) {
        this.incremental = incremental;
        this.namenodeAddr = namenodeAddr;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public InetSocketAddress getNamenodeAddr() {
        return this.namenodeAddr;
    }

    public String toString() {
        return "BlockReportOptions{incremental=" + this.incremental + ", namenodeAddr=" + this.namenodeAddr + "}";
    }

    public static class Factory {
        private boolean incremental = false;
        private InetSocketAddress namenodeAddr;

        public Factory setIncremental(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        public Factory setNamenodeAddr(InetSocketAddress namenodeAddr) {
            this.namenodeAddr = namenodeAddr;
            return this;
        }

        public BlockReportOptions build() {
            return new BlockReportOptions(this.incremental, this.namenodeAddr);
        }
    }
}

