/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.ListenerBasedPendingReadOp;
import org.apache.bookkeeper.client.ReadLastConfirmedOp;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerRecoveryOp
implements BookkeeperInternalCallbacks.ReadEntryListener,
AsyncCallback.AddCallback {
    static final Logger LOG = LoggerFactory.getLogger(LedgerRecoveryOp.class);
    final LedgerHandle lh;
    final ClientContext clientCtx;
    final CompletableFuture<LedgerHandle> promise;
    final AtomicLong readCount = new AtomicLong(0L);
    final AtomicLong writeCount = new AtomicLong(0L);
    volatile boolean readDone = false;
    volatile long startEntryToRead;
    volatile long endEntryToRead;
    LedgerMetadata metadataForRecovery;
    @VisibleForTesting
    BookkeeperInternalCallbacks.ReadEntryListener entryListener = null;

    public LedgerRecoveryOp(LedgerHandle lh, ClientContext clientCtx) {
        this.promise = new CompletableFuture();
        this.lh = lh;
        this.clientCtx = clientCtx;
    }

    @VisibleForTesting
    LedgerRecoveryOp setEntryListener(BookkeeperInternalCallbacks.ReadEntryListener entryListener) {
        this.entryListener = entryListener;
        return this;
    }

    public CompletableFuture<LedgerHandle> initiate() {
        ReadLastConfirmedOp rlcop = new ReadLastConfirmedOp(this.clientCtx.getBookieClient(), this.lh.distributionSchedule, this.lh.macManager, this.lh.ledgerId, this.lh.getCurrentEnsemble(), this.lh.ledgerKey, new ReadLastConfirmedOp.LastConfirmedDataCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readLastConfirmedDataComplete(int rc, DigestManager.RecoveryData data) {
                if (rc == 0) {
                    LedgerHandle ledgerHandle = LedgerRecoveryOp.this.lh;
                    synchronized (ledgerHandle) {
                        LedgerRecoveryOp.this.lh.lastAddPushed = LedgerRecoveryOp.this.lh.lastAddConfirmed = data.getLastAddConfirmed();
                        LedgerRecoveryOp.this.lh.length = data.getLength();
                        LedgerRecoveryOp.this.lh.pendingAddsSequenceHead = LedgerRecoveryOp.this.lh.lastAddConfirmed;
                        LedgerRecoveryOp.this.startEntryToRead = LedgerRecoveryOp.this.endEntryToRead = LedgerRecoveryOp.this.lh.lastAddConfirmed;
                    }
                    LedgerRecoveryOp.this.metadataForRecovery = LedgerRecoveryOp.this.lh.getLedgerMetadata();
                    LedgerRecoveryOp.this.doRecoveryRead();
                } else if (rc == -102) {
                    LedgerRecoveryOp.this.submitCallback(rc);
                } else {
                    LedgerRecoveryOp.this.submitCallback(-1);
                }
            }
        });
        rlcop.initiateWithFencing();
        return this.promise;
    }

    private void submitCallback(int rc) {
        if (0 == rc) {
            this.clientCtx.getClientStats().getRecoverAddCountLogger().registerSuccessfulValue(this.writeCount.get());
            this.clientCtx.getClientStats().getRecoverReadCountLogger().registerSuccessfulValue(this.readCount.get());
            this.promise.complete(this.lh);
        } else {
            this.clientCtx.getClientStats().getRecoverAddCountLogger().registerFailedValue(this.writeCount.get());
            this.clientCtx.getClientStats().getRecoverReadCountLogger().registerFailedValue(this.readCount.get());
            this.promise.completeExceptionally(BKException.create(rc));
        }
    }

    private void doRecoveryRead() {
        if (!this.promise.isDone()) {
            this.startEntryToRead = this.endEntryToRead + 1L;
            this.endEntryToRead += (long)this.clientCtx.getConf().recoveryReadBatchSize;
            new RecoveryReadOp(this.lh, this.clientCtx, this.startEntryToRead, this.endEntryToRead, this, null).initiate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryComplete(int rc, LedgerHandle lh, LedgerEntry entry, Object ctx) {
        BookkeeperInternalCallbacks.ReadEntryListener listener = this.entryListener;
        if (null != listener) {
            listener.onEntryComplete(rc, lh, entry, ctx);
        }
        if (!this.promise.isDone() && !this.readDone && rc == 0) {
            this.readCount.incrementAndGet();
            byte[] data = entry.getEntry();
            LedgerHandle ledgerHandle = lh;
            synchronized (ledgerHandle) {
                lh.length = entry.getLength() - (long)data.length;
                if (entry.getEntryId() != lh.lastAddPushed + 1L) {
                    LOG.error("Unexpected to recovery add entry {} as entry {} for ledger {}.", new Object[]{entry.getEntryId(), lh.lastAddPushed + 1L, lh.getId()});
                    rc = -999;
                }
            }
            if (0 == rc) {
                lh.asyncRecoveryAddEntry(data, 0, data.length, this, null);
                if (entry.getEntryId() == this.endEntryToRead) {
                    this.doRecoveryRead();
                }
                return;
            }
        }
        if (rc == -13 || rc == -7) {
            this.readDone = true;
            if (this.readCount.get() == this.writeCount.get()) {
                this.submitCallback(0);
            }
            return;
        }
        if (0 != rc && !this.promise.isDone()) {
            LOG.error("Failure {} while reading entries: ({} - {}), ledger: {} while recovering ledger", new Object[]{BKException.getMessage(rc), this.startEntryToRead, this.endEntryToRead, lh.getId()});
            this.submitCallback(rc);
        } else if (0 == rc) {
            LOG.warn("Successfully read entry {} for ledger {}, but readDone is already {}", new Object[]{entry.getEntryId(), lh.getId(), this.readDone});
        }
    }

    @Override
    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        if (rc != 0) {
            LOG.error("Failure {} while writing entry: {} while recovering ledger: {}", new Object[]{BKException.codeLogger(rc), entryId + 1L, lh.ledgerId});
            this.submitCallback(rc);
            return;
        }
        long numAdd = this.writeCount.incrementAndGet();
        if (this.readDone && this.readCount.get() == numAdd) {
            this.submitCallback(rc);
        }
    }

    class RecoveryReadOp
    extends ListenerBasedPendingReadOp {
        RecoveryReadOp(LedgerHandle lh, ClientContext clientCtx, long startEntryId, long endEntryId, BookkeeperInternalCallbacks.ReadEntryListener cb, Object ctx) {
            super(lh, clientCtx, startEntryId, endEntryId, cb, ctx, true);
        }

        @Override
        protected LedgerMetadata getLedgerMetadata() {
            return LedgerRecoveryOp.this.metadataForRecovery;
        }
    }
}

