/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.ext.web.LanguageHeader;
import io.vertx.ext.web.impl.HeaderParser;
import io.vertx.ext.web.impl.ParsableHeaderValue;

public class ParsableLanguageValue
extends ParsableHeaderValue
implements LanguageHeader {
    private String[] parsedValues = null;

    public ParsableLanguageValue(String headerContent) {
        super(headerContent);
    }

    @Override
    public String tag() {
        return this.subtag(0);
    }

    @Override
    public String language() {
        String value = this.tag();
        return value == null ? null : value.toLowerCase();
    }

    @Override
    public @Nullable String subtag() {
        return this.subtag(1);
    }

    @Override
    public @Nullable String country() {
        String value = this.subtag(1);
        return value == null ? null : value.toUpperCase();
    }

    @Override
    public @Nullable String variant() {
        String value = this.subtag(2);
        return value == null ? null : value.toUpperCase();
    }

    @Override
    public @Nullable String subtag(int level) {
        this.ensureHeaderProcessed();
        if (level < this.parsedValues.length) {
            return this.parsedValues[level];
        }
        return null;
    }

    @Override
    public int subtagCount() {
        return this.parsedValues.length;
    }

    @Override
    protected boolean isMatchedBy2(ParsableHeaderValue matchTry) {
        ParsableLanguageValue myMatchTry = (ParsableLanguageValue)matchTry;
        this.ensureHeaderProcessed();
        for (int i = 0; i < myMatchTry.parsedValues.length; ++i) {
            String match = myMatchTry.parsedValues[i];
            String against = this.parsedValues[i];
            if ("*".equals(match) || match.equalsIgnoreCase(against)) continue;
            return false;
        }
        return super.isMatchedBy2(myMatchTry);
    }

    @Override
    protected void ensureHeaderProcessed() {
        super.ensureHeaderProcessed();
        this.parsedValues = HeaderParser.parseLanguageValue(this.value);
    }
}

