/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookieid;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.tools.cli.helpers.ClientCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.versioning.Versioned;

public class SearchReplaceBookieIdCommand
extends ClientCommand<Flags> {
    private static final String NAME = "searchreplace";
    private static final String DESC = "Search all ledgers for a bookie ID and replace";

    public SearchReplaceBookieIdCommand() {
        this(new Flags());
    }

    public SearchReplaceBookieIdCommand(Flags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    protected void run(org.apache.bookkeeper.client.api.BookKeeper bk, Flags flags) throws Exception {
        try (BookKeeperAdmin admin = new BookKeeperAdmin((BookKeeper)bk);){
            LedgerManager ledgerManager = ((BookKeeper)bk).getLedgerManager();
            long i = 0L;
            BookieSocketAddress fromAddr = new BookieSocketAddress(flags.from);
            BookieSocketAddress toAddr = new BookieSocketAddress(flags.to);
            System.out.println(String.format("Replacing bookie id %s with %s in metadata", fromAddr, toAddr));
            RateLimiter limiter = RateLimiter.create((double)flags.rate);
            for (Long lid : admin.listLedgers()) {
                Versioned md = (Versioned)ledgerManager.readLedgerMetadata(lid.longValue()).get();
                if (((LedgerMetadata)md.getValue()).getAllEnsembles().entrySet().stream().anyMatch(e -> ((List)e.getValue()).contains(fromAddr))) {
                    limiter.acquire();
                    LedgerMetadataBuilder builder = LedgerMetadataBuilder.from((LedgerMetadata)((LedgerMetadata)md.getValue()));
                    ((LedgerMetadata)md.getValue()).getAllEnsembles().entrySet().stream().filter(e -> ((List)e.getValue()).contains(fromAddr)).forEach(e -> {
                        ArrayList ensemble = new ArrayList((Collection)e.getValue());
                        ensemble.replaceAll(a -> {
                            if (a.equals((Object)fromAddr)) {
                                return toAddr;
                            }
                            return a;
                        });
                        builder.replaceEnsembleEntry(((Long)e.getKey()).longValue(), ensemble);
                    });
                    LedgerMetadata newMeta = builder.build();
                    if (flags.verbose) {
                        System.out.println("Replacing ledger " + lid + " metadata ...");
                        System.out.println(((LedgerMetadata)md.getValue()).toSafeString());
                        System.out.println("with ...");
                        System.out.println(newMeta.toSafeString());
                    }
                    ++i;
                    if (!flags.dryRun) {
                        ledgerManager.writeLedgerMetadata(lid.longValue(), newMeta, md.getVersion()).get();
                    }
                }
                if (i < flags.max) continue;
                System.out.println("Max number of ledgers processed, exiting");
                break;
            }
            System.out.println("Replaced bookie ID in " + i + " ledgers");
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-f", "--from"}, description="Bookie ID to search for", required=true)
        private String from;
        @Parameter(names={"-t", "--to"}, description="Bookie ID to replace with", required=true)
        private String to;
        @Parameter(names={"-m", "--max"}, description="Maximum number of replacements to make")
        private long max = Long.MAX_VALUE;
        @Parameter(names={"-r", "--rate"}, description="Rate limit (updates per second)")
        private int rate = Integer.MAX_VALUE;
        @Parameter(names={"--dry-run"}, description="Don't actually write anything")
        private boolean dryRun = false;
        @Parameter(names={"-v", "--verbose"}, description="Verbose output")
        private boolean verbose = false;

        public Flags from(String from) {
            this.from = from;
            return this;
        }

        public Flags to(String to) {
            this.to = to;
            return this;
        }

        public Flags max(long max) {
            this.max = max;
            return this;
        }

        public Flags rate(int rate) {
            this.rate = rate;
            return this;
        }

        public Flags dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Flags verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }
    }
}

