/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package trait

// The Prometheus trait configures a Prometheus-compatible endpoint. It also creates a `PodMonitor` resource,
// so that the endpoint can be scraped automatically, when using the Prometheus operator.
//
// The metrics are exposed using Micrometer Metrics.
//
// WARNING: The creation of the `PodMonitor` resource requires the https://github.com/coreos/prometheus-operator[Prometheus Operator]
// custom resource definition to be installed.
// You can set `pod-monitor` to `false` for the Prometheus trait to work without the Prometheus Operator.
//
// WARNING: By default the metrics API is not available in JSON
//
// The Prometheus trait is disabled by default.
//
// +camel-k:trait=prometheus.
type PrometheusTrait struct {
	Trait `json:",inline" property:",squash"`

	// Whether a `PodMonitor` resource is created (default `true`).
	PodMonitor *bool `json:"podMonitor,omitempty" property:"pod-monitor"`
	// The `PodMonitor` resource labels, applicable when `pod-monitor` is `true`.
	PodMonitorLabels []string `json:"podMonitorLabels,omitempty" property:"pod-monitor-labels"`
}
