/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.codahale.metrics.Histogram;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.DataStorageSpec;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ArrayClustering;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.MessageParams;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RejectException;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.TrackedDataInputPlus;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.vint.VIntCoding;
import org.github.jamm.Unmetered;

public class RowIndexEntry
extends AbstractRowIndexEntry {
    private static final BigFormat FORMAT = BigFormat.getInstance();
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RowIndexEntry(0L));
    static final int CACHE_NOT_INDEXED = 0;
    static final int CACHE_INDEXED = 1;
    static final int CACHE_INDEXED_SHALLOW = 2;
    static final Histogram indexEntrySizeHistogram;
    static final Histogram indexInfoCountHistogram;
    static final Histogram indexInfoGetsHistogram;
    static final Histogram indexInfoReadsHistogram;

    public RowIndexEntry(long position) {
        super(position);
    }

    @Override
    public boolean isIndexed() {
        return this.blockCount() > 1;
    }

    public boolean indexOnHeap() {
        return false;
    }

    @Override
    public DeletionTime deletionTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int blockCount() {
        return 0;
    }

    public BigFormat getSSTableFormat() {
        return FORMAT;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    public static RowIndexEntry create(long dataFilePosition, long indexFilePosition, DeletionTime deletionTime, long headerLength, int columnIndexCount, int indexedPartSize, List<IndexInfo> indexSamples, int[] offsets, ISerializer<IndexInfo> idxInfoSerializer, Version version) {
        if (indexSamples != null && indexSamples.size() > 1) {
            return new IndexedEntry(dataFilePosition, deletionTime, headerLength, indexSamples.toArray(new IndexInfo[indexSamples.size()]), offsets, indexedPartSize, idxInfoSerializer, version);
        }
        if (columnIndexCount > 1) {
            return new ShallowIndexedEntry(dataFilePosition, indexFilePosition, deletionTime, headerLength, columnIndexCount, indexedPartSize, idxInfoSerializer, version);
        }
        return new RowIndexEntry(dataFilePosition);
    }

    public IndexInfoRetriever openWithIndex(FileHandle indexFile) {
        return null;
    }

    private static int serializedSize(DeletionTime deletionTime, long headerLength, int columnIndexCount, Version version) {
        int dlt = (int)DeletionTime.getSerializer(version).serializedSize(deletionTime);
        return TypeSizes.sizeofUnsignedVInt(headerLength) + dlt + TypeSizes.sizeofUnsignedVInt(columnIndexCount);
    }

    public void serialize(DataOutputPlus out, ByteBuffer indexInfo) throws IOException {
        out.writeUnsignedVInt(this.position);
        out.writeUnsignedVInt32(0);
    }

    @Override
    public void serializeForCache(DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt(this.position);
        out.writeByte(0);
    }

    static {
        DefaultNameFactory factory = new DefaultNameFactory("Index", "RowIndexEntry");
        indexEntrySizeHistogram = CassandraMetricsRegistry.Metrics.histogram(factory.createMetricName("IndexedEntrySize"), false);
        indexInfoCountHistogram = CassandraMetricsRegistry.Metrics.histogram(factory.createMetricName("IndexInfoCount"), false);
        indexInfoGetsHistogram = CassandraMetricsRegistry.Metrics.histogram(factory.createMetricName("IndexInfoGets"), false);
        indexInfoReadsHistogram = CassandraMetricsRegistry.Metrics.histogram(factory.createMetricName("IndexInfoReads"), false);
    }

    public static class RowIndexEntryReadSizeTooLargeException
    extends RejectException {
        public RowIndexEntryReadSizeTooLargeException(String message) {
            super(message);
        }
    }

    private static abstract class FileIndexInfoRetriever
    implements IndexInfoRetriever {
        final long indexInfoFilePosition;
        final ISerializer<IndexInfo> idxInfoSerializer;
        final FileDataInput indexReader;
        int retrievals;

        FileIndexInfoRetriever(long indexInfoFilePosition, FileDataInput indexReader, ISerializer<IndexInfo> idxInfoSerializer) {
            this.indexInfoFilePosition = indexInfoFilePosition;
            this.idxInfoSerializer = idxInfoSerializer;
            this.indexReader = indexReader;
        }

        @Override
        public final IndexInfo columnsIndex(int index) throws IOException {
            ++this.retrievals;
            return this.fetchIndex(index);
        }

        abstract IndexInfo fetchIndex(int var1) throws IOException;

        @Override
        public void close() throws IOException {
            this.indexReader.close();
            indexInfoGetsHistogram.update(this.retrievals);
            indexInfoReadsHistogram.update(this.retrievals);
        }
    }

    public static interface IndexInfoRetriever
    extends AutoCloseable {
        public IndexInfo columnsIndex(int var1) throws IOException;

        @Override
        public void close() throws IOException;
    }

    private static final class ShallowInfoRetriever
    extends FileIndexInfoRetriever {
        private final int offsetsOffset;

        private ShallowInfoRetriever(long indexInfoFilePosition, int offsetsOffset, FileDataInput indexReader, ISerializer<IndexInfo> idxInfoSerializer) {
            super(indexInfoFilePosition, indexReader, idxInfoSerializer);
            this.offsetsOffset = offsetsOffset;
        }

        @Override
        IndexInfo fetchIndex(int index) throws IOException {
            this.indexReader.seek(this.indexInfoFilePosition + (long)this.offsetsOffset + (long)(index * 4));
            int indexInfoPos = this.indexReader.readInt();
            this.indexReader.seek(this.indexInfoFilePosition + (long)indexInfoPos);
            return (IndexInfo)this.idxInfoSerializer.deserialize(this.indexReader);
        }
    }

    private static final class ShallowIndexedEntry
    extends RowIndexEntry {
        private static final long BASE_SIZE = ObjectSizes.measure(new ShallowIndexedEntry(0L, 0L, DeletionTime.LIVE, 0L, 10, 0, null, BigFormat.getInstance().getLatestVersion()));
        private final long indexFilePosition;
        private final DeletionTime deletionTime;
        private final long headerLength;
        private final int columnsIndexCount;
        private final int indexedPartSize;
        private final int offsetsOffset;
        @Unmetered
        private final ISerializer<IndexInfo> idxInfoSerializer;
        private final int fieldsSerializedSize;
        private final Version version;

        private ShallowIndexedEntry(long dataFilePosition, long indexFilePosition, DeletionTime deletionTime, long headerLength, int columnIndexCount, int indexedPartSize, ISerializer<IndexInfo> idxInfoSerializer, Version version) {
            super(dataFilePosition);
            assert (columnIndexCount > 1);
            this.indexFilePosition = indexFilePosition;
            this.headerLength = headerLength;
            this.deletionTime = deletionTime;
            this.columnsIndexCount = columnIndexCount;
            this.indexedPartSize = indexedPartSize;
            this.idxInfoSerializer = idxInfoSerializer;
            this.version = version;
            this.fieldsSerializedSize = RowIndexEntry.serializedSize(deletionTime, headerLength, columnIndexCount, this.version);
            this.offsetsOffset = indexedPartSize + this.fieldsSerializedSize - this.columnsIndexCount * 4;
        }

        private ShallowIndexedEntry(long dataFilePosition, DataInputPlus in, IndexInfo.Serializer idxInfoSerializer, Version version) throws IOException {
            super(dataFilePosition);
            this.indexFilePosition = in.readUnsignedVInt();
            this.headerLength = in.readUnsignedVInt();
            this.version = version;
            this.deletionTime = DeletionTime.getSerializer(version).deserialize(in);
            this.columnsIndexCount = in.readUnsignedVInt32();
            this.indexedPartSize = in.readUnsignedVInt32();
            this.idxInfoSerializer = idxInfoSerializer;
            this.fieldsSerializedSize = RowIndexEntry.serializedSize(this.deletionTime, this.headerLength, this.columnsIndexCount, this.version);
            this.offsetsOffset = this.indexedPartSize + this.fieldsSerializedSize - this.columnsIndexCount * 4;
        }

        @Override
        public int blockCount() {
            return this.columnsIndexCount;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public IndexInfoRetriever openWithIndex(FileHandle indexFile) {
            indexEntrySizeHistogram.update(this.indexedPartSize + this.fieldsSerializedSize);
            indexInfoCountHistogram.update(this.columnsIndexCount);
            return new ShallowInfoRetriever(this.indexFilePosition + (long)VIntCoding.computeUnsignedVIntSize(this.position) + (long)VIntCoding.computeUnsignedVIntSize(this.indexedPartSize + this.fieldsSerializedSize) + (long)this.fieldsSerializedSize, this.offsetsOffset - this.fieldsSerializedSize, indexFile.createReader(), this.idxInfoSerializer);
        }

        @Override
        public long unsharedHeapSize() {
            return BASE_SIZE;
        }

        @Override
        public void serialize(DataOutputPlus out, ByteBuffer indexInfo) throws IOException {
            out.writeUnsignedVInt(this.position);
            out.writeUnsignedVInt32(this.fieldsSerializedSize + indexInfo.limit());
            out.writeUnsignedVInt(this.headerLength);
            DeletionTime.getSerializer(this.version).serialize(this.deletionTime, out);
            out.writeUnsignedVInt32(this.columnsIndexCount);
            out.write(indexInfo);
        }

        @Override
        public void serializeForCache(DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt(this.position);
            out.writeByte(2);
            out.writeUnsignedVInt(this.indexFilePosition);
            out.writeUnsignedVInt(this.headerLength);
            DeletionTime.getSerializer(this.version).serialize(this.deletionTime, out);
            out.writeUnsignedVInt32(this.columnsIndexCount);
            out.writeUnsignedVInt32(this.indexedPartSize);
        }

        static void skipForCache(DataInputPlus in, Version version) throws IOException {
            in.readUnsignedVInt();
            in.readUnsignedVInt();
            DeletionTime.getSerializer(version).skip(in);
            in.readUnsignedVInt();
            in.readUnsignedVInt();
        }
    }

    private static final class IndexedEntry
    extends RowIndexEntry {
        private static final long BASE_SIZE = ObjectSizes.measure(new IndexedEntry(0L, DeletionTime.LIVE, 0L, null, null, 0, null, BigFormat.getInstance().getLatestVersion()));
        private final DeletionTime deletionTime;
        private final long headerLength;
        private final IndexInfo[] columnsIndex;
        private final int[] offsets;
        private final int indexedPartSize;
        @Unmetered
        private final ISerializer<IndexInfo> idxInfoSerializer;
        private final Version version;

        private IndexedEntry(long dataFilePosition, DeletionTime deletionTime, long headerLength, IndexInfo[] columnsIndex, int[] offsets, int indexedPartSize, ISerializer<IndexInfo> idxInfoSerializer, Version version) {
            super(dataFilePosition);
            this.headerLength = headerLength;
            this.deletionTime = deletionTime;
            this.columnsIndex = columnsIndex;
            this.offsets = offsets;
            this.indexedPartSize = indexedPartSize;
            this.idxInfoSerializer = idxInfoSerializer;
            this.version = version;
        }

        private IndexedEntry(long dataFilePosition, DataInputPlus in, DeletionTime deletionTime, long headerLength, int columnIndexCount, IndexInfo.Serializer idxInfoSerializer, int indexedPartSize, Version version) throws IOException {
            super(dataFilePosition);
            int i;
            this.headerLength = headerLength;
            this.deletionTime = deletionTime;
            int columnsIndexCount = columnIndexCount;
            this.columnsIndex = new IndexInfo[columnsIndexCount];
            for (i = 0; i < columnsIndexCount; ++i) {
                this.columnsIndex[i] = idxInfoSerializer.deserialize(in);
            }
            this.offsets = new int[this.columnsIndex.length];
            for (i = 0; i < this.offsets.length; ++i) {
                this.offsets[i] = in.readInt();
            }
            this.indexedPartSize = indexedPartSize;
            this.idxInfoSerializer = idxInfoSerializer;
            this.version = version;
        }

        private IndexedEntry(long dataFilePosition, DataInputPlus in, ISerializer<IndexInfo> idxInfoSerializer, Version version) throws IOException {
            super(dataFilePosition);
            this.headerLength = in.readUnsignedVInt();
            this.version = version;
            this.deletionTime = DeletionTime.getSerializer(version).deserialize(in);
            int columnsIndexCount = in.readUnsignedVInt32();
            TrackedDataInputPlus trackedIn = new TrackedDataInputPlus(in);
            this.columnsIndex = new IndexInfo[columnsIndexCount];
            for (int i = 0; i < columnsIndexCount; ++i) {
                this.columnsIndex[i] = idxInfoSerializer.deserialize(trackedIn);
            }
            this.offsets = null;
            this.indexedPartSize = (int)trackedIn.getBytesRead();
            this.idxInfoSerializer = idxInfoSerializer;
        }

        @Override
        public boolean indexOnHeap() {
            return true;
        }

        @Override
        public int blockCount() {
            return this.columnsIndex.length;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public IndexInfoRetriever openWithIndex(FileHandle indexFile) {
            indexEntrySizeHistogram.update(RowIndexEntry.serializedSize(this.deletionTime, this.headerLength, this.columnsIndex.length, this.version) + this.indexedPartSize);
            indexInfoCountHistogram.update(this.columnsIndex.length);
            return new IndexInfoRetriever(){
                private int retrievals;

                @Override
                public IndexInfo columnsIndex(int index) {
                    ++this.retrievals;
                    return columnsIndex[index];
                }

                @Override
                public void close() {
                    indexInfoGetsHistogram.update(this.retrievals);
                }
            };
        }

        @Override
        public long unsharedHeapSize() {
            long entrySize = 0L;
            for (IndexInfo idx : this.columnsIndex) {
                entrySize += idx.unsharedHeapSize();
            }
            return BASE_SIZE + entrySize + ObjectSizes.sizeOfReferenceArray(this.columnsIndex.length);
        }

        @Override
        public void serialize(DataOutputPlus out, ByteBuffer indexInfo) throws IOException {
            assert (this.indexedPartSize != Integer.MIN_VALUE);
            out.writeUnsignedVInt(this.position);
            out.writeUnsignedVInt32(RowIndexEntry.serializedSize(this.deletionTime, this.headerLength, this.columnsIndex.length, this.version) + this.indexedPartSize);
            out.writeUnsignedVInt(this.headerLength);
            DeletionTime.getSerializer(this.version).serialize(this.deletionTime, out);
            out.writeUnsignedVInt32(this.columnsIndex.length);
            for (IndexInfo info : this.columnsIndex) {
                this.idxInfoSerializer.serialize(info, out);
            }
            for (int offset : this.offsets) {
                out.writeInt(offset);
            }
        }

        @Override
        public void serializeForCache(DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt(this.position);
            out.writeByte(1);
            out.writeUnsignedVInt(this.headerLength);
            DeletionTime.getSerializer(this.version).serialize(this.deletionTime, out);
            out.writeUnsignedVInt32(this.blockCount());
            for (IndexInfo indexInfo : this.columnsIndex) {
                this.idxInfoSerializer.serialize(indexInfo, out);
            }
        }

        static void skipForCache(DataInputPlus in, Version version) throws IOException {
            in.readUnsignedVInt();
            DeletionTime.getSerializer(version).skip(in);
            in.readUnsignedVInt();
            in.readUnsignedVInt();
        }
    }

    public static final class Serializer
    implements IndexSerializer {
        private final IndexInfo.Serializer idxInfoSerializer;
        private final Version version;
        private final TableMetrics tableMetrics;

        public Serializer(Version version, SerializationHeader header, TableMetrics tableMetrics) {
            this.idxInfoSerializer = IndexInfo.serializer(version, header);
            this.version = version;
            this.tableMetrics = tableMetrics;
        }

        @Override
        public IndexInfo.Serializer indexInfoSerializer() {
            return this.idxInfoSerializer;
        }

        @Override
        public void serialize(RowIndexEntry rie, DataOutputPlus out, ByteBuffer indexInfo) throws IOException {
            rie.serialize(out, indexInfo);
        }

        @Override
        public void serializeForCache(RowIndexEntry rie, DataOutputPlus out) throws IOException {
            rie.serializeForCache(out);
        }

        @Override
        public RowIndexEntry deserializeForCache(DataInputPlus in) throws IOException {
            long position = in.readUnsignedVInt();
            switch (in.readByte()) {
                case 0: {
                    return new RowIndexEntry(position);
                }
                case 1: {
                    return new IndexedEntry(position, in, this.idxInfoSerializer, this.version);
                }
                case 2: {
                    return new ShallowIndexedEntry(position, in, this.idxInfoSerializer, this.version);
                }
            }
            throw new AssertionError();
        }

        public static void skipForCache(DataInputPlus in, Version version) throws IOException {
            in.readUnsignedVInt();
            switch (in.readByte()) {
                case 0: {
                    break;
                }
                case 1: {
                    IndexedEntry.skipForCache(in, version);
                    break;
                }
                case 2: {
                    ShallowIndexedEntry.skipForCache(in, version);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        @Override
        public RowIndexEntry deserialize(DataInputPlus in, long indexFilePosition) throws IOException {
            long position = in.readUnsignedVInt();
            int size = in.readUnsignedVInt32();
            if (size == 0) {
                return new RowIndexEntry(position);
            }
            long headerLength = in.readUnsignedVInt();
            DeletionTime deletionTime = DeletionTime.getSerializer(this.version).deserialize(in);
            int columnsIndexCount = in.readUnsignedVInt32();
            this.checkSize(columnsIndexCount, size);
            int indexedPartSize = size - RowIndexEntry.serializedSize(deletionTime, headerLength, columnsIndexCount, this.version);
            if (size <= DatabaseDescriptor.getColumnIndexCacheSize()) {
                return new IndexedEntry(position, in, deletionTime, headerLength, columnsIndexCount, this.idxInfoSerializer, indexedPartSize, this.version);
            }
            in.skipBytes(indexedPartSize);
            return new ShallowIndexedEntry(position, indexFilePosition, deletionTime, headerLength, columnsIndexCount, indexedPartSize, this.idxInfoSerializer, this.version);
        }

        private void checkSize(int entries, int bytes) {
            Long current;
            ReadCommand command = ReadCommand.getCommand();
            if (command == null || SchemaConstants.isSystemKeyspace(command.metadata().keyspace) || !DatabaseDescriptor.getReadThresholdsEnabled()) {
                return;
            }
            DataStorageSpec.LongBytesBound warnThreshold = DatabaseDescriptor.getRowIndexReadSizeWarnThreshold();
            DataStorageSpec.LongBytesBound failThreshold = DatabaseDescriptor.getRowIndexReadSizeFailThreshold();
            if (warnThreshold == null && failThreshold == null) {
                return;
            }
            long estimatedMemory = Serializer.estimateMaterializedIndexSize(entries, bytes);
            if (this.tableMetrics != null) {
                this.tableMetrics.rowIndexSize.update(estimatedMemory);
            }
            if (failThreshold != null && estimatedMemory > failThreshold.toBytes()) {
                String msg = String.format("Query %s attempted to access a large RowIndexEntry estimated to be %d bytes in-memory (total entries: %d, total bytes: %d) but the max allowed is %s; query aborted  (see row_index_read_size_fail_threshold)", command.toCQLString(), estimatedMemory, entries, bytes, failThreshold);
                MessageParams.remove(ParamType.ROW_INDEX_READ_SIZE_WARN);
                MessageParams.add(ParamType.ROW_INDEX_READ_SIZE_FAIL, estimatedMemory);
                throw new RowIndexEntryReadSizeTooLargeException(msg);
            }
            if (warnThreshold != null && estimatedMemory > warnThreshold.toBytes() && ((current = (Long)MessageParams.get(ParamType.ROW_INDEX_READ_SIZE_WARN)) == null || current.compareTo(estimatedMemory) < 0)) {
                MessageParams.add(ParamType.ROW_INDEX_READ_SIZE_WARN, estimatedMemory);
            }
        }

        private static long estimateMaterializedIndexSize(int entries, int bytes) {
            long overhead = IndexInfo.EMPTY_SIZE + ArrayClustering.EMPTY_SIZE + DeletionTime.EMPTY_SIZE;
            return overhead * (long)entries + (long)bytes;
        }

        @Override
        public long deserializePositionAndSkip(DataInputPlus in) throws IOException {
            long position = in.readUnsignedVInt();
            int size = in.readUnsignedVInt32();
            if (size > 0) {
                in.skipBytesFully(size);
            }
            return position;
        }

        public static long readPosition(DataInputPlus in) throws IOException {
            return in.readUnsignedVInt();
        }

        public static void skip(DataInputPlus in, Version version) throws IOException {
            Serializer.readPosition(in);
            Serializer.skipPromotedIndex(in);
        }

        private static void skipPromotedIndex(DataInputPlus in) throws IOException {
            int size = in.readUnsignedVInt32();
            if (size <= 0) {
                return;
            }
            in.skipBytesFully(size);
        }
    }

    public static interface IndexSerializer {
        public void serialize(RowIndexEntry var1, DataOutputPlus var2, ByteBuffer var3) throws IOException;

        public RowIndexEntry deserialize(DataInputPlus var1, long var2) throws IOException;

        default public RowIndexEntry deserialize(RandomAccessReader reader) throws IOException {
            return this.deserialize(reader, reader.getFilePointer());
        }

        default public RowIndexEntry deserialize(FileDataInput input) throws IOException {
            return this.deserialize(input, input.getFilePointer());
        }

        public void serializeForCache(RowIndexEntry var1, DataOutputPlus var2) throws IOException;

        public RowIndexEntry deserializeForCache(DataInputPlus var1) throws IOException;

        public long deserializePositionAndSkip(DataInputPlus var1) throws IOException;

        public ISerializer indexInfoSerializer();
    }
}

