/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.UnfilteredValidation;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.sstable.AbstractSSTableIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.IndexState;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.btree.BTree;

public class SSTableReversedIterator
extends AbstractSSTableIterator<RowIndexEntry> {
    private int slice;

    public SSTableReversedIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry, Slices slices, ColumnFilter columns, FileHandle ifile) {
        super(sstable, file, key, indexEntry, slices, columns, ifile);
    }

    @Override
    protected AbstractSSTableIterator.Reader createReaderInternal(RowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile, Version version) {
        return indexEntry.isIndexed() ? new ReverseIndexedReader(indexEntry, file, shouldCloseFile) : new ReverseReader(file, shouldCloseFile);
    }

    @Override
    public boolean isReverseOrder() {
        return true;
    }

    @Override
    protected int nextSliceIndex() {
        int next = this.slice++;
        return this.slices.size() - (next + 1);
    }

    @Override
    protected boolean hasMoreSlices() {
        return this.slice < this.slices.size();
    }

    private static class SkipLastIterator
    extends AbstractIterator<Unfiltered> {
        private final Iterator<Unfiltered> iterator;

        private SkipLastIterator(Iterator<Unfiltered> iterator) {
            this.iterator = iterator;
        }

        @Override
        protected Unfiltered computeNext() {
            if (!this.iterator.hasNext()) {
                return (Unfiltered)this.endOfData();
            }
            Unfiltered next = this.iterator.next();
            return this.iterator.hasNext() ? next : (Unfiltered)this.endOfData();
        }
    }

    private class ReusablePartitionData {
        private final TableMetadata metadata;
        private final DecoratedKey partitionKey;
        private final RegularAndStaticColumns columns;
        private MutableDeletionInfo.Builder deletionBuilder;
        private MutableDeletionInfo deletionInfo;
        private BTree.Builder<Row> rowBuilder;
        private ImmutableBTreePartition built;

        private ReusablePartitionData(TableMetadata metadata, DecoratedKey partitionKey, RegularAndStaticColumns columns, int initialRowCapacity) {
            this.metadata = metadata;
            this.partitionKey = partitionKey;
            this.columns = columns;
            this.rowBuilder = BTree.builder(metadata.comparator, initialRowCapacity);
        }

        public void add(Unfiltered unfiltered) {
            if (unfiltered.isRow()) {
                this.rowBuilder.add((Row)unfiltered);
            } else {
                this.deletionBuilder.add((RangeTombstoneMarker)unfiltered);
            }
        }

        public void reset() {
            this.built = null;
            this.rowBuilder.reuse();
            this.deletionBuilder = MutableDeletionInfo.builder(SSTableReversedIterator.this.partitionLevelDeletion, SSTableReversedIterator.this.metadata().comparator, false);
        }

        public void build() {
            this.deletionInfo = this.deletionBuilder.build();
            this.built = new ImmutableBTreePartition(this.metadata, this.partitionKey, this.columns, Rows.EMPTY_STATIC_ROW, this.rowBuilder.build(), this.deletionInfo, EncodingStats.NO_STATS);
            this.deletionBuilder = null;
        }
    }

    private class ReverseIndexedReader
    extends ReverseReader {
        private final IndexState indexState;
        private Slice slice;
        private int lastBlockIdx;

        private ReverseIndexedReader(RowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
            this.indexState = new IndexState(this, ((SSTableReversedIterator)SSTableReversedIterator.this).metadata.comparator, indexEntry, true, SSTableReversedIterator.this.ifile);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.indexState.close();
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            this.slice = slice;
            if (this.indexState.isDone()) {
                this.iterator = Collections.emptyIterator();
                return;
            }
            int startIdx = this.indexState.findBlockIndex(slice.end(), this.indexState.currentBlockIdx());
            if (startIdx < 0) {
                this.iterator = Collections.emptyIterator();
                this.indexState.setToBlock(startIdx);
                return;
            }
            this.lastBlockIdx = this.indexState.findBlockIndex(slice.start(), startIdx);
            if (this.lastBlockIdx >= this.indexState.blocksCount()) {
                assert (startIdx >= this.indexState.blocksCount());
                this.iterator = Collections.emptyIterator();
                return;
            }
            if (startIdx >= this.indexState.blocksCount()) {
                startIdx = this.indexState.blocksCount() - 1;
            }
            this.indexState.setToBlock(startIdx);
            this.readCurrentBlock(false, startIdx != this.lastBlockIdx);
        }

        @Override
        protected boolean hasNextInternal() throws IOException {
            int nextBlockIdx;
            if (super.hasNextInternal()) {
                return true;
            }
            do {
                if ((nextBlockIdx = this.indexState.currentBlockIdx() - 1) < 0 || nextBlockIdx < this.lastBlockIdx) {
                    return false;
                }
                this.indexState.setToBlock(nextBlockIdx);
                this.readCurrentBlock(true, nextBlockIdx != this.lastBlockIdx);
            } while (!this.iterator.hasNext() && nextBlockIdx > this.lastBlockIdx);
            return this.iterator.hasNext();
        }

        private void readCurrentBlock(boolean hasPreviousBlock, boolean hasNextBlock) throws IOException {
            if (this.buffer == null) {
                this.buffer = this.createBuffer(this.indexState.blocksCount());
            }
            boolean canIncludeSliceStart = !hasNextBlock;
            boolean canIncludeSliceEnd = !hasPreviousBlock;
            this.loadFromDisk(canIncludeSliceStart ? this.slice.start() : null, canIncludeSliceEnd ? this.slice.end() : null, hasPreviousBlock, hasNextBlock);
            this.setIterator(this.slice);
        }

        @Override
        protected boolean stopReadingDisk() throws IOException {
            return this.indexState.isPastCurrentBlock();
        }
    }

    private class ReverseReader
    extends AbstractSSTableIterator.AbstractReader {
        protected ReusablePartitionData buffer;
        protected Iterator<Unfiltered> iterator;
        protected boolean skipFirstIteratedItem;
        protected boolean skipLastIteratedItem;

        private ReverseReader(FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
        }

        protected ReusablePartitionData createBuffer(int blocksCount) {
            int estimatedRowCount = 16;
            int columnCount = SSTableReversedIterator.this.metadata().regularColumns().size();
            if (columnCount == 0 || SSTableReversedIterator.this.metadata().clusteringColumns().isEmpty()) {
                estimatedRowCount = 1;
            } else {
                try {
                    int estimatedRowsPerPartition = (int)(SSTableReversedIterator.this.sstable.getEstimatedCellPerPartitionCount().percentile(0.75) / (long)columnCount);
                    estimatedRowCount = Math.max(estimatedRowsPerPartition / blocksCount, 1);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return new ReusablePartitionData(SSTableReversedIterator.this.metadata(), SSTableReversedIterator.this.partitionKey(), SSTableReversedIterator.this.columns(), estimatedRowCount);
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            if (this.buffer == null) {
                this.buffer = this.createBuffer(1);
                this.loadFromDisk(null, slice.end(), false, false);
            }
            this.setIterator(slice);
        }

        protected void setIterator(Slice slice) {
            assert (this.buffer != null);
            this.iterator = this.buffer.built.unfilteredIterator(SSTableReversedIterator.this.columns, Slices.with(SSTableReversedIterator.this.metadata().comparator, slice), true);
            if (!this.iterator.hasNext()) {
                return;
            }
            if (this.skipFirstIteratedItem) {
                this.iterator.next();
            }
            if (this.skipLastIteratedItem) {
                this.iterator = new SkipLastIterator(this.iterator);
            }
        }

        @Override
        protected boolean hasNextInternal() throws IOException {
            if (this.iterator == null) {
                this.setForSlice(Slice.ALL);
            }
            return this.iterator.hasNext();
        }

        @Override
        protected Unfiltered nextInternal() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }

        protected boolean stopReadingDisk() throws IOException {
            return false;
        }

        protected void loadFromDisk(ClusteringBound<?> start, ClusteringBound<?> end, boolean hasPreviousBlock, boolean hasNextBlock) throws IOException {
            assert (start == null || !hasNextBlock);
            this.buffer.reset();
            this.skipFirstIteratedItem = false;
            this.skipLastIteratedItem = false;
            if (start != null) {
                while (this.deserializer.hasNext() && this.deserializer.compareNextTo(start) <= 0 && !this.stopReadingDisk()) {
                    if (this.deserializer.nextIsRow()) {
                        this.deserializer.skipNext();
                        continue;
                    }
                    this.updateOpenMarker((RangeTombstoneMarker)this.deserializer.readNext());
                }
            }
            if (this.openMarker != null) {
                ClusteringBound<?> markerStart = start == null ? BufferClusteringBound.BOTTOM : start;
                this.buffer.add(new RangeTombstoneBoundMarker(markerStart, this.openMarker));
                if (hasNextBlock) {
                    this.skipLastIteratedItem = true;
                }
            }
            while (this.deserializer.hasNext() && (end == null || this.deserializer.compareNextTo(end) < 0) && !this.stopReadingDisk()) {
                Unfiltered unfiltered = this.deserializer.readNext();
                UnfilteredValidation.maybeValidateUnfiltered(unfiltered, SSTableReversedIterator.this.metadata(), SSTableReversedIterator.this.key, SSTableReversedIterator.this.sstable);
                if (!unfiltered.isEmpty()) {
                    this.buffer.add(unfiltered);
                }
                if (!unfiltered.isRangeTombstoneMarker()) continue;
                this.updateOpenMarker((RangeTombstoneMarker)unfiltered);
            }
            if (this.openMarker != null) {
                ClusteringBound<?> markerEnd = end == null ? BufferClusteringBound.TOP : end;
                this.buffer.add(new RangeTombstoneBoundMarker(markerEnd, this.openMarker));
                if (hasPreviousBlock) {
                    this.skipFirstIteratedItem = true;
                }
            }
            this.buffer.build();
        }
    }
}

