/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import org.apache.cassandra.config.CassandraRelevantEnv;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.PathUtils;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HeapUtils {
    private static final Logger logger = LoggerFactory.getLogger(HeapUtils.class);
    private static final Lock DUMP_LOCK = new ReentrantLock();

    public static void logHeapHistogram() {
        try {
            logger.info("Trying to log the heap histogram using jcmd");
            Long processId = HeapUtils.getProcessId();
            if (processId == null) {
                logger.error("The process ID could not be retrieved. Skipping heap histogram generation.");
                return;
            }
            String jcmdPath = HeapUtils.getJcmdPath();
            String jcmdCommand = jcmdPath == null ? "jcmd" : jcmdPath;
            String[] histoCommands = new String[]{jcmdCommand, processId.toString(), "GC.class_histogram"};
            HeapUtils.logProcessOutput(Runtime.getRuntime().exec(histoCommands));
        }
        catch (Throwable e) {
            logger.error("The heap histogram could not be generated due to the following error: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String maybeCreateHeapDump() {
        if (DUMP_LOCK.tryLock()) {
            try {
                if (DatabaseDescriptor.getDumpHeapOnUncaughtException()) {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Path absoluteBasePath = DatabaseDescriptor.getHeapDumpPath();
                    if (absoluteBasePath == null) {
                        DatabaseDescriptor.setDumpHeapOnUncaughtException(false);
                        throw new RuntimeException("Cannot create heap dump unless -XX:HeapDumpPath or cassandra.yaml:heap_dump_path is specified.");
                    }
                    long maxMemoryBytes = Runtime.getRuntime().maxMemory();
                    long freeSpaceBytes = PathUtils.tryGetSpace(absoluteBasePath, FileStore::getUnallocatedSpace);
                    if (freeSpaceBytes < 2L * maxMemoryBytes) {
                        throw new RuntimeException("Cannot allocated space for a heap dump snapshot. There are only " + freeSpaceBytes + " bytes free at " + absoluteBasePath + ".");
                    }
                    HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
                    String filename = String.format("pid%s-epoch%s.hprof", HeapUtils.getProcessId().toString(), Clock.Global.currentTimeMillis());
                    String fullPath = File.getPath(absoluteBasePath.toString(), filename).toString();
                    logger.info("Writing heap dump to {} on partition w/ {} free bytes...", (Object)absoluteBasePath, (Object)freeSpaceBytes);
                    mxBean.dumpHeap(fullPath, false);
                    logger.info("Heap dump written to {}", (Object)fullPath);
                    DatabaseDescriptor.setDumpHeapOnUncaughtException(false);
                    String string = fullPath;
                    return string;
                }
                logger.debug("Heap dump creation on uncaught exceptions is disabled.");
            }
            catch (Throwable e) {
                logger.warn("Unable to create heap dump.", e);
            }
            finally {
                DUMP_LOCK.unlock();
            }
        } else {
            logger.debug("Heap dump creation is already in progress. Request aborted.");
        }
        return null;
    }

    private static String getJcmdPath() {
        String javaHome = CassandraRelevantEnv.JAVA_HOME.getString();
        if (javaHome == null) {
            return null;
        }
        File javaBinDirectory = new File(javaHome, "bin");
        Object[] files = javaBinDirectory.tryList((dir, name) -> name.startsWith("jcmd"));
        return ArrayUtils.isEmpty((Object[])files) ? null : ((File)files[0]).path();
    }

    private static void logProcessOutput(Process p) throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            StrBuilder builder = new StrBuilder();
            while ((line = input.readLine()) != null) {
                builder.appendln(line);
            }
            logger.info(builder.toString());
        }
    }

    private static Long getProcessId() {
        long pid = NativeLibrary.getProcessID();
        if (pid >= 0L) {
            return pid;
        }
        return HeapUtils.getProcessIdFromJvmName();
    }

    private static Long getProcessIdFromJvmName() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Long.valueOf(jvmName.split("@")[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private HeapUtils() {
    }
}

