/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.cassandra.utils.concurrent.LightweightRecyclerPoolHolder;

public interface LightweightRecycler<T>
extends LightweightRecyclerPoolHolder<T> {
    default public T reuse() {
        return this.get().pollFirst();
    }

    default public T reuseOrAllocate(Supplier<T> supplier) {
        T reuse = this.reuse();
        return reuse != null ? reuse : supplier.get();
    }

    default public boolean tryRecycle(T t) {
        Objects.requireNonNull(t);
        ArrayDeque pool = this.get();
        if (pool.size() < this.capacity()) {
            if (t instanceof Collection) {
                ((Collection)t).clear();
            }
            pool.offerFirst(t);
            return true;
        }
        return false;
    }

    default public int available() {
        return this.get().size();
    }

    public int capacity();
}

