/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.DataObject;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.PropertyException;

class DataObjectAccessor
implements Accessor {
    protected String propertyName;

    DataObjectAccessor(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName");
        }
        this.propertyName = propertyName;
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Object getValue(Object object) throws PropertyException {
        try {
            DataObject dataObject = (DataObject)object;
            return dataObject.readPropertyDirectly(this.propertyName);
        }
        catch (ClassCastException e) {
            throw new PropertyException("Object is not a DataObject: '" + object.getClass().getName() + "'", (Accessor)this, object, (Throwable)e, new Object[0]);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading DataObject property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }

    @Override
    public void setValue(Object object, Object newValue) throws PropertyException {
        try {
            ((DataObject)object).writePropertyDirectly(this.propertyName, newValue);
        }
        catch (ClassCastException e) {
            throw new PropertyException("Object is not a DataObject: '" + object.getClass().getName() + "'", (Accessor)this, object, (Throwable)e, new Object[0]);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading DataObject property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }
}

