/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LikeNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.access.sqlbuilder.sqltree.TrimmingColumnNode;
import org.apache.cayenne.access.translator.select.TypeAwareSQLTreeProcessor;
import org.apache.cayenne.dba.postgres.sqltree.PositionFunctionNode;
import org.apache.cayenne.dba.postgres.sqltree.PostgresExtractFunctionNode;
import org.apache.cayenne.dba.postgres.sqltree.PostgresLikeNode;
import org.apache.cayenne.dba.postgres.sqltree.PostgresLimitOffsetNode;
import org.apache.cayenne.value.GeoJson;
import org.apache.cayenne.value.Wkt;

public class PostgreSQLTreeProcessor
extends TypeAwareSQLTreeProcessor {
    private static final Set<String> EXTRACT_FUNCTION_NAMES = new HashSet<String>(Arrays.asList("DAY_OF_MONTH", "DAY", "MONTH", "HOUR", "WEEK", "YEAR", "DAY_OF_WEEK", "DAY_OF_YEAR", "MINUTE", "SECOND"));

    public PostgreSQLTreeProcessor() {
        this.registerProcessor(NodeType.LIMIT_OFFSET, this::onLimitOffsetNode);
        this.registerProcessor(NodeType.LIKE, this::onLikeNode);
        this.registerProcessor(NodeType.FUNCTION, this::onFunctionNode);
        this.registerColumnProcessor(DEFAULT_TYPE, (p, c, i) -> Optional.of(new TrimmingColumnNode((ColumnNode)c)));
        this.registerColumnProcessor(Wkt.class, (parent, child, i) -> Optional.of(PostgreSQLTreeProcessor.wrapInFunction(child, "ST_AsText")));
        this.registerColumnProcessor(GeoJson.class, (parent, child, i) -> Optional.of(PostgreSQLTreeProcessor.wrapInFunction(child, "ST_AsGeoJSON")));
        this.registerValueProcessor(Wkt.class, (parent, child, i) -> Optional.of(PostgreSQLTreeProcessor.wrapInFunction(child, "ST_GeomFromText")));
        this.registerValueProcessor(GeoJson.class, (parent, child, i) -> Optional.of(PostgreSQLTreeProcessor.wrapInFunction(child, "ST_GeomFromGeoJSON")));
    }

    protected Optional<Node> onLimitOffsetNode(Node parent, LimitOffsetNode child, int index) {
        return Optional.of(new PostgresLimitOffsetNode(child));
    }

    protected Optional<Node> onLikeNode(Node parent, LikeNode child, int index) {
        return child.isIgnoreCase() ? Optional.of(new PostgresLikeNode(child.isNot(), child.getEscape())) : Optional.empty();
    }

    protected Optional<Node> onFunctionNode(Node parent, FunctionNode child, int index) {
        Node replacement = null;
        String functionName = child.getFunctionName();
        if (EXTRACT_FUNCTION_NAMES.contains(functionName)) {
            replacement = new PostgresExtractFunctionNode(functionName);
        } else if ("CURRENT_DATE".equals(functionName) || "CURRENT_TIME".equals(functionName) || "CURRENT_TIMESTAMP".equals(functionName)) {
            replacement = new FunctionNode(functionName, child.getAlias(), false);
        } else if ("LOCATE".equals(functionName)) {
            replacement = new PositionFunctionNode(child.getAlias());
        }
        return Optional.ofNullable(replacement);
    }
}

