/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EJBQLQueryDescriptor;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.ProcedureQueryDescriptor;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.project.validation.DataChannelValidator;
import org.apache.cayenne.project.validation.DataMapValidator;
import org.apache.cayenne.project.validation.DataNodeValidator;
import org.apache.cayenne.project.validation.DbAttributeValidator;
import org.apache.cayenne.project.validation.DbEntityValidator;
import org.apache.cayenne.project.validation.DbRelationshipValidator;
import org.apache.cayenne.project.validation.EJBQLQueryValidator;
import org.apache.cayenne.project.validation.EmbeddableAttributeValidator;
import org.apache.cayenne.project.validation.EmbeddableValidator;
import org.apache.cayenne.project.validation.ObjAttributeValidator;
import org.apache.cayenne.project.validation.ObjEntityValidator;
import org.apache.cayenne.project.validation.ObjRelationshipValidator;
import org.apache.cayenne.project.validation.ProcedureParameterValidator;
import org.apache.cayenne.project.validation.ProcedureQueryValidator;
import org.apache.cayenne.project.validation.ProcedureValidator;
import org.apache.cayenne.project.validation.ProjectValidator;
import org.apache.cayenne.project.validation.SQLTemplateValidator;
import org.apache.cayenne.project.validation.SelectQueryValidator;
import org.apache.cayenne.validation.ValidationResult;

public class DefaultProjectValidator
implements ProjectValidator {
    private DataChannelValidator dataChannelValidator = new DataChannelValidator();
    private DataNodeValidator nodeValidator = new DataNodeValidator();
    private DataMapValidator mapValidator = new DataMapValidator();
    private ObjEntityValidator objEntityValidator = new ObjEntityValidator();
    private ObjAttributeValidator objAttrValidator = new ObjAttributeValidator();
    private ObjRelationshipValidator objRelValidator = new ObjRelationshipValidator();
    private DbEntityValidator dbEntityValidator = new DbEntityValidator();
    private DbAttributeValidator dbAttrValidator = new DbAttributeValidator();
    private DbRelationshipValidator dbRelValidator = new DbRelationshipValidator();
    private EmbeddableAttributeValidator embeddableAttributeValidator = new EmbeddableAttributeValidator();
    private EmbeddableValidator embeddableValidator = new EmbeddableValidator();
    private ProcedureValidator procedureValidator = new ProcedureValidator();
    private ProcedureParameterValidator procedureParameterValidator = new ProcedureParameterValidator();
    private SelectQueryValidator selectQueryValidator = new SelectQueryValidator();
    private ProcedureQueryValidator procedureQueryValidator = new ProcedureQueryValidator();
    private EJBQLQueryValidator ejbqlQueryValidator = new EJBQLQueryValidator();
    private SQLTemplateValidator sqlTemplateValidator = new SQLTemplateValidator();

    DefaultProjectValidator() {
    }

    @Override
    public ValidationResult validate(ConfigurationNode node) {
        return node.acceptVisitor(new ValidationVisitor());
    }

    class ValidationVisitor
    implements ConfigurationNodeVisitor<ValidationResult> {
        private ValidationResult validationResult = new ValidationResult();

        ValidationVisitor() {
        }

        @Override
        public ValidationResult visitDataChannelDescriptor(DataChannelDescriptor channelDescriptor) {
            DefaultProjectValidator.this.dataChannelValidator.validate(channelDescriptor, this.validationResult);
            for (DataNodeDescriptor node : channelDescriptor.getNodeDescriptors()) {
                this.visitDataNodeDescriptor(node);
            }
            for (DataMap map : channelDescriptor.getDataMaps()) {
                this.visitDataMap(map);
            }
            return this.validationResult;
        }

        @Override
        public ValidationResult visitDataMap(DataMap dataMap) {
            DefaultProjectValidator.this.mapValidator.validate(dataMap, this.validationResult);
            for (Embeddable embeddable : dataMap.getEmbeddables()) {
                this.visitEmbeddable(embeddable);
            }
            for (ObjEntity objEntity : dataMap.getObjEntities()) {
                this.visitObjEntity(objEntity);
            }
            for (DbEntity dbEntity : dataMap.getDbEntities()) {
                this.visitDbEntity(dbEntity);
            }
            for (Procedure procedure : dataMap.getProcedures()) {
                this.visitProcedure(procedure);
            }
            for (QueryDescriptor queryDescriptor : dataMap.getQueryDescriptors()) {
                this.visitQuery(queryDescriptor);
            }
            return this.validationResult;
        }

        @Override
        public ValidationResult visitDataNodeDescriptor(DataNodeDescriptor nodeDescriptor) {
            DefaultProjectValidator.this.nodeValidator.validate(nodeDescriptor, this.validationResult);
            return this.validationResult;
        }

        @Override
        public ValidationResult visitDbAttribute(DbAttribute attribute) {
            DefaultProjectValidator.this.dbAttrValidator.validate(attribute, this.validationResult);
            return this.validationResult;
        }

        @Override
        public ValidationResult visitDbEntity(DbEntity entity) {
            DefaultProjectValidator.this.dbEntityValidator.validate(entity, this.validationResult);
            for (DbAttribute attr : entity.getAttributes()) {
                this.visitDbAttribute(attr);
            }
            for (DbRelationship rel : entity.getRelationships()) {
                this.visitDbRelationship(rel);
            }
            return this.validationResult;
        }

        @Override
        public ValidationResult visitDbRelationship(DbRelationship relationship) {
            DefaultProjectValidator.this.dbRelValidator.validate(relationship, this.validationResult);
            return this.validationResult;
        }

        @Override
        public ValidationResult visitEmbeddable(Embeddable embeddable) {
            DefaultProjectValidator.this.embeddableValidator.validate(embeddable, this.validationResult);
            for (EmbeddableAttribute attr : embeddable.getAttributes()) {
                this.visitEmbeddableAttribute(attr);
            }
            return this.validationResult;
        }

        @Override
        public ValidationResult visitEmbeddableAttribute(EmbeddableAttribute attribute) {
            DefaultProjectValidator.this.embeddableAttributeValidator.validate(attribute, this.validationResult);
            return this.validationResult;
        }

        @Override
        public ValidationResult visitObjAttribute(ObjAttribute attribute) {
            DefaultProjectValidator.this.objAttrValidator.validate(attribute, this.validationResult);
            return this.validationResult;
        }

        @Override
        public ValidationResult visitObjEntity(ObjEntity entity) {
            DefaultProjectValidator.this.objEntityValidator.validate(entity, this.validationResult);
            for (ObjAttribute attr : entity.getAttributes()) {
                this.visitObjAttribute(attr);
            }
            for (ObjRelationship rel : entity.getRelationships()) {
                this.visitObjRelationship(rel);
            }
            return this.validationResult;
        }

        @Override
        public ValidationResult visitObjRelationship(ObjRelationship relationship) {
            DefaultProjectValidator.this.objRelValidator.validate(relationship, this.validationResult);
            return this.validationResult;
        }

        @Override
        public ValidationResult visitProcedure(Procedure procedure) {
            DefaultProjectValidator.this.procedureValidator.validate(procedure, this.validationResult);
            ProcedureParameter parameter = procedure.getResultParam();
            if (parameter != null) {
                this.visitProcedureParameter(parameter);
            }
            for (ProcedureParameter procPar : procedure.getCallOutParameters()) {
                this.visitProcedureParameter(procPar);
            }
            for (ProcedureParameter procPar : procedure.getCallParameters()) {
                this.visitProcedureParameter(procPar);
            }
            return this.validationResult;
        }

        @Override
        public ValidationResult visitProcedureParameter(ProcedureParameter parameter) {
            DefaultProjectValidator.this.procedureParameterValidator.validate(parameter, this.validationResult);
            return this.validationResult;
        }

        @Override
        public ValidationResult visitQuery(QueryDescriptor query) {
            switch (query.getType()) {
                case "SelectQuery": {
                    DefaultProjectValidator.this.selectQueryValidator.validate((SelectQueryDescriptor)query, this.validationResult);
                    break;
                }
                case "SQLTemplate": {
                    DefaultProjectValidator.this.sqlTemplateValidator.validate((SQLTemplateDescriptor)query, this.validationResult);
                    break;
                }
                case "ProcedureQuery": {
                    DefaultProjectValidator.this.procedureQueryValidator.validate((ProcedureQueryDescriptor)query, this.validationResult);
                    break;
                }
                case "EJBQLQuery": {
                    DefaultProjectValidator.this.ejbqlQueryValidator.validate((EJBQLQueryDescriptor)query, this.validationResult);
                }
            }
            return this.validationResult;
        }
    }
}

