/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junitx.framework.ListAssert;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestAbstractConfiguration {
    protected abstract AbstractConfiguration getConfiguration();

    protected abstract AbstractConfiguration getEmptyConfiguration();

    @Test
    public void testGetProperty() {
        AbstractConfiguration config = this.getConfiguration();
        Assert.assertEquals((String)"key1", (Object)"value1", (Object)config.getProperty("key1"));
        Assert.assertEquals((String)"key2", (Object)"value2", (Object)config.getProperty("key2"));
        Assert.assertNull((String)"key3", (Object)config.getProperty("key3"));
    }

    @Test
    public void testList() {
        AbstractConfiguration config = this.getConfiguration();
        List list = config.getList("list");
        Assert.assertNotNull((String)"list not found", (Object)config.getProperty("list"));
        Assert.assertEquals((String)"list size", (long)2L, (long)list.size());
        Assert.assertTrue((String)"'value1' is not in the list", (boolean)list.contains("value1"));
        Assert.assertTrue((String)"'value2' is not in the list", (boolean)list.contains("value2"));
    }

    @Test
    public void testListEscaped() {
        Assert.assertEquals((String)"Wrong value for escaped list", (Object)"value1,value2", (Object)this.getConfiguration().getString("listesc"));
    }

    @Test
    public void testAddPropertyDirect() {
        AbstractConfiguration config = this.getConfiguration();
        config.addPropertyDirect("key3", (Object)"value3");
        Assert.assertEquals((String)"key3", (Object)"value3", (Object)config.getProperty("key3"));
        config.addPropertyDirect("key3", (Object)"value4");
        config.addPropertyDirect("key3", (Object)"value5");
        List list = config.getList("key3");
        Assert.assertNotNull((String)"no list found for the 'key3' property", (Object)list);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("value3");
        expected.add("value4");
        expected.add("value5");
        ListAssert.assertEquals((String)"values for the 'key3' property", expected, (List)list);
    }

    @Test
    public void testIsEmpty() {
        AbstractConfiguration config = this.getConfiguration();
        Assert.assertFalse((String)"the configuration is empty", (boolean)config.isEmpty());
        Assert.assertTrue((String)"the configuration is not empty", (boolean)this.getEmptyConfiguration().isEmpty());
    }

    @Test
    public void testContainsKey() {
        AbstractConfiguration config = this.getConfiguration();
        Assert.assertTrue((String)"key1 not found", (boolean)config.containsKey("key1"));
        Assert.assertFalse((String)"key3 found", (boolean)config.containsKey("key3"));
    }

    @Test
    public void testClearProperty() {
        AbstractConfiguration config = this.getConfiguration();
        config.clearProperty("key2");
        Assert.assertFalse((String)"key2 not cleared", (boolean)config.containsKey("key2"));
    }

    @Test
    public void testGetKeys() {
        AbstractConfiguration config = this.getConfiguration();
        Iterator keys = config.getKeys();
        ArrayList<String> expectedKeys = new ArrayList<String>();
        expectedKeys.add("key1");
        expectedKeys.add("key2");
        expectedKeys.add("list");
        expectedKeys.add("listesc");
        Assert.assertNotNull((String)"null iterator", (Object)keys);
        Assert.assertTrue((String)"empty iterator", (boolean)keys.hasNext());
        ArrayList actualKeys = new ArrayList();
        while (keys.hasNext()) {
            actualKeys.add(keys.next());
        }
        ListAssert.assertEquals((String)"keys", expectedKeys, actualKeys);
    }

    @Test
    public void testSetLogger() {
        AbstractConfiguration config = this.getEmptyConfiguration();
        Assert.assertNotNull((String)"Default logger is null", (Object)config.getLogger());
        Log log = LogFactory.getLog(config.getClass());
        config.setLogger(log);
        Assert.assertSame((String)"Logger was not set", (Object)log, (Object)config.getLogger());
    }

    @Test
    public void testGetBigIntegerConversion() {
        AbstractConfiguration config = this.getConfiguration();
        try {
            config.getBigInteger("key1");
            Assert.fail((String)"No conversion exception thrown!");
        }
        catch (ConversionException cex) {
            Assert.assertEquals((String)"Wrong exception message", (Object)"'key1' doesn't map to a BigInteger object", (Object)cex.getMessage());
        }
    }
}

