/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.apache.commons.configuration2.TestAbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMapConfiguration
extends TestAbstractConfiguration {
    private static final String KEY = "key1";
    private static final String SPACE_VALUE = "   Value with whitespace  ";
    private static final String TRIM_VALUE = "   Value with whitespace  ".trim();

    @Override
    protected AbstractConfiguration getConfiguration() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY, "value1");
        map.put("key2", "value2");
        map.put("list", "value1, value2");
        map.put("listesc", "value1\\,value2");
        MapConfiguration config = new MapConfiguration(map);
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return config;
    }

    @Override
    protected AbstractConfiguration getEmptyConfiguration() {
        return new MapConfiguration(new HashMap());
    }

    @Test
    void testAddProperty() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.addProperty(KEY, (Object)TRIM_VALUE);
        config.addProperty(KEY, (Object)"anotherValue");
        List values = config.getList(KEY);
        Assertions.assertEquals((int)3, (int)values.size());
    }

    @Test
    void testClone() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        MapConfiguration copy = (MapConfiguration)config.clone();
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        Assertions.assertTrue((boolean)comp.compare((Configuration)config, (Configuration)copy));
    }

    @Test
    void testCloneInterpolation() {
        String keyAnswer = "answer";
        String keyValue = "value";
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.addProperty("answer", (Object)"The answer is ${value}.");
        config.addProperty("value", (Object)42);
        MapConfiguration clone = (MapConfiguration)config.clone();
        clone.setProperty("value", (Object)43);
        Assertions.assertEquals((Object)"The answer is 42.", (Object)config.getString("answer"));
        Assertions.assertEquals((Object)"The answer is 43.", (Object)clone.getString("answer"));
    }

    @Test
    void testCloneModify() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.addEventListener(ConfigurationEvent.ANY, (EventListener)new EventListenerTestImpl(config));
        MapConfiguration copy = (MapConfiguration)config.clone();
        Assertions.assertTrue((boolean)copy.getEventListeners(ConfigurationEvent.ANY).isEmpty());
        config.addProperty("cloneTest", (Object)Boolean.TRUE);
        Assertions.assertFalse((boolean)copy.containsKey("cloneTest"));
        copy.clearProperty(KEY);
        Assertions.assertEquals((Object)"value1", (Object)config.getString(KEY));
    }

    @Override
    @Test
    public void testContainsValue() {
        Assertions.assertFalse((boolean)this.getConfiguration().containsValue(null));
        Assertions.assertFalse((boolean)this.getConfiguration().containsValue((Object)""));
    }

    @Test
    void testGetMap() {
        HashMap map = new HashMap();
        MapConfiguration conf = new MapConfiguration(map);
        Assertions.assertEquals(map, (Object)conf.getMap());
    }

    @Test
    void testGetPropertyTrim() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.getMap().put(KEY, SPACE_VALUE);
        Assertions.assertEquals((Object)TRIM_VALUE, (Object)config.getProperty(KEY));
    }

    @Test
    void testGetPropertyTrimDisabled() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.getMap().put(KEY, SPACE_VALUE);
        config.setTrimmingDisabled(true);
        Assertions.assertEquals((Object)SPACE_VALUE, (Object)config.getProperty(KEY));
    }

    @Test
    void testGetPropertyTrimNoSplit() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.getMap().put(KEY, SPACE_VALUE);
        config.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        Assertions.assertEquals((Object)SPACE_VALUE, (Object)config.getProperty(KEY));
    }

    @Test
    void testNullMap() {
        Assertions.assertThrows(NullPointerException.class, () -> new MapConfiguration((Map)null));
        Assertions.assertThrows(NullPointerException.class, () -> new MapConfiguration((Properties)null));
    }
}

