/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.web;

import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.TestAbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.web.ServletConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestServletConfiguration
extends TestAbstractConfiguration {
    @Override
    protected AbstractConfiguration getConfiguration() {
        Properties parameters = new Properties();
        parameters.setProperty("key1", "value1");
        parameters.setProperty("key2", "value2");
        parameters.setProperty("list", "value1, value2");
        parameters.setProperty("listesc", "value1\\,value2");
        final ServletConfig config = this.mockServletConfig(parameters);
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            public ServletConfig getServletConfig() {
                return config;
            }
        };
        ServletConfiguration servletConfiguration = new ServletConfiguration((Servlet)servlet);
        servletConfiguration.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return servletConfiguration;
    }

    @Override
    protected AbstractConfiguration getEmptyConfiguration() {
        return new ServletConfiguration(this.mockServletConfig(new Properties()));
    }

    private ServletConfig mockServletConfig(Properties parameters) {
        ServletConfig config = (ServletConfig)Mockito.mock(ServletConfig.class);
        Mockito.when((Object)config.getInitParameterNames()).thenAnswer(invocation -> parameters.keys());
        Mockito.when((Object)config.getInitParameter((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            String name = (String)invocation.getArgument(0, String.class);
            return parameters.getProperty(name);
        });
        return config;
    }

    @Override
    @Test
    public void testAddPropertyDirect() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testAddPropertyDirect());
    }

    @Override
    @Test
    public void testClearProperty() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testClearProperty());
    }

    @Override
    @Test
    public void testContainsValue() {
        Assertions.assertFalse((boolean)this.getConfiguration().containsValue(null));
        Assertions.assertFalse((boolean)this.getConfiguration().containsValue((Object)""));
    }
}

