/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class EraseTest {
    private final AtomicInteger intRef = new AtomicInteger();
    private final AtomicBoolean boolRef = new AtomicBoolean();

    EraseTest() {
    }

    @Test
    void testAcceptIOBiConsumerOfTUTU() {
        Erase.accept((e, f) -> this.boolRef.set(this.intRef.compareAndSet(0, (int)e)), (Object)1, (Object)true);
        Assertions.assertEquals((int)1, (int)this.intRef.get());
        Assertions.assertTrue((boolean)this.boolRef.get());
        Assertions.assertThrows(IOException.class, () -> Erase.accept(TestUtils.throwingIOBiConsumer(), null, (Object)1));
    }

    @Test
    void testAcceptIOConsumerOfTT() {
        Erase.accept(e -> this.intRef.compareAndSet(0, (int)e), (Object)1);
        Assertions.assertEquals((int)1, (int)this.intRef.get());
        Assertions.assertThrows(IOException.class, () -> Erase.accept(TestUtils.throwingIOConsumer(), (Object)1));
    }

    @Test
    void testApplyIOBiFunctionOfQsuperTQsuperUQextendsRTU() {
        Assertions.assertTrue((boolean)((Boolean)Erase.apply((i, b) -> this.boolRef.compareAndSet(false, this.intRef.compareAndSet(0, (int)i)), (Object)1, (Object)Boolean.TRUE)));
        Assertions.assertThrows(IOException.class, () -> Erase.apply(TestUtils.throwingIOBiFunction(), (Object)1, (Object)Boolean.TRUE));
    }

    @Test
    void testApplyIOFunctionOfQsuperTQextendsRT() {
        Assertions.assertTrue((boolean)((Boolean)Erase.apply(e -> this.intRef.compareAndSet(0, (int)e), (Object)1)));
        Assertions.assertThrows(IOException.class, () -> Erase.apply(TestUtils.throwingIOFunction(), (Object)1));
    }

    @Test
    void testCompare() {
        Assertions.assertEquals((int)0, (int)Erase.compare(String::compareTo, (Object)"A", (Object)"A"));
        Assertions.assertEquals((int)-1, (int)Erase.compare(String::compareTo, (Object)"A", (Object)"B"));
        Assertions.assertEquals((int)1, (int)Erase.compare(String::compareTo, (Object)"B", (Object)"A"));
        Assertions.assertThrows(IOException.class, () -> Erase.compare(TestUtils.throwingIOComparator(), null, null));
    }

    @Test
    void testGet() {
        Assertions.assertEquals((int)0, (Integer)((Integer)Erase.get(() -> this.intRef.get())));
        Assertions.assertThrows(IOException.class, () -> Erase.get(TestUtils.throwingIOSupplier()));
    }

    @Test
    void testRethrow() {
        Assertions.assertThrows(IOException.class, () -> Erase.rethrow((Throwable)new IOException()));
    }

    @Test
    void testRun() {
        Erase.run(() -> this.intRef.set(1));
        Assertions.assertEquals((int)1, (int)this.intRef.get());
        Assertions.assertThrows(IOException.class, () -> Erase.run((IORunnable)TestUtils.throwingIORunnable()));
    }

    @Test
    void testTest() {
        Assertions.assertTrue((boolean)Erase.test(e -> this.intRef.compareAndSet(0, (int)e), (Object)1));
        Assertions.assertThrows(IOException.class, () -> Erase.test(TestUtils.throwingIOPredicate(), (Object)1));
    }
}

