/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.CurrencyValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;

class CurrencyValidatorTest {
    private static final char CURRENCY_SYMBOL = '\u00a4';
    private String usDollar;
    private String ukPound;

    CurrencyValidatorTest() {
    }

    @BeforeEach
    protected void setUp() {
        this.usDollar = new DecimalFormatSymbols(Locale.US).getCurrencySymbol();
        this.ukPound = new DecimalFormatSymbols(Locale.UK).getCurrencySymbol();
    }

    @Test
    void testFormatType() {
        Assertions.assertEquals((int)1, (int)CurrencyValidator.getInstance().getFormatType(), (String)"Format Type A");
        Assertions.assertEquals((int)1, (int)CurrencyValidator.getInstance().getFormatType(), (String)"Format Type B");
    }

    @Test
    void testIntegerInvalid() {
        CurrencyValidator validator = new CurrencyValidator(true, false);
        Assertions.assertFalse((boolean)validator.isValid(this.ukPound + "1,234.56", Locale.UK), (String)"UK positive");
        Assertions.assertFalse((boolean)validator.isValid("-" + this.ukPound + "1,234.56", Locale.UK), (String)"UK negative");
        Assertions.assertFalse((boolean)validator.isValid(this.usDollar + "1,234.56", Locale.US), (String)"US positive");
        Assertions.assertFalse((boolean)validator.isValid("(" + this.usDollar + "1,234.56)", Locale.US), (String)"US negative");
    }

    @Test
    @DefaultLocale(value="en-GB")
    void testIntegerValid() {
        CurrencyValidator validator = new CurrencyValidator();
        BigDecimal expected = new BigDecimal("1234.00");
        BigDecimal negative = new BigDecimal("-1234.00");
        String ukPlus = NumberFormat.getCurrencyInstance(Locale.UK).format(1234L);
        String ukMinus = NumberFormat.getCurrencyInstance(Locale.UK).format(-1234L);
        String usPlus = NumberFormat.getCurrencyInstance(Locale.US).format(1234L);
        String usMinus = NumberFormat.getCurrencyInstance(Locale.US).format(-1234L);
        Assertions.assertEquals((Object)expected, (Object)validator.validate(ukPlus), (String)"Default locale");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(ukPlus, Locale.UK), (String)"UK locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate(ukMinus, Locale.UK), (String)"UK negative");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(usPlus, Locale.US), (String)"US locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate(usMinus, Locale.US), (String)"US negative");
    }

    @Test
    void testInvalid() {
        BigDecimalValidator validator = CurrencyValidator.getInstance();
        String ukPlus = NumberFormat.getCurrencyInstance(Locale.UK).format(1234.56);
        String usPlus = NumberFormat.getCurrencyInstance(Locale.US).format(1234.56);
        String ukMinus = NumberFormat.getCurrencyInstance(Locale.UK).format(-1234.56);
        String usMinus = NumberFormat.getCurrencyInstance(Locale.US).format(-1234.56);
        Assertions.assertFalse((boolean)validator.isValid(null), (String)"isValid() Null Value");
        Assertions.assertFalse((boolean)validator.isValid(""), (String)"isValid() Empty Value");
        Assertions.assertNull((Object)validator.validate(null), (String)"validate() Null Value");
        Assertions.assertNull((Object)validator.validate(""), (String)"validate() Empty Value");
        Assertions.assertFalse((boolean)validator.isValid(usPlus, Locale.UK), (String)("UK wrong symbol: " + usPlus));
        if (ukMinus.startsWith("-")) {
            Assertions.assertFalse((boolean)validator.isValid("(" + this.ukPound + "1,234.56)", Locale.UK), (String)("UK wrong negative: " + ukMinus));
        } else {
            Assertions.assertFalse((boolean)validator.isValid("-" + this.ukPound + "1,234.56", Locale.UK), (String)("UK wrong negative: " + ukMinus));
        }
        Assertions.assertFalse((boolean)validator.isValid(ukPlus, Locale.US), (String)("US wrong symbol: " + ukPlus));
        if (usMinus.startsWith("-")) {
            Assertions.assertFalse((boolean)validator.isValid("(" + this.usDollar + "1,234.56)", Locale.US), (String)("UK wrong negative: " + usMinus));
        } else {
            Assertions.assertFalse((boolean)validator.isValid("-" + this.usDollar + "1,234.56", Locale.US), (String)("UK wrong negative: " + usMinus));
        }
    }

    @Test
    @DefaultLocale(value="en-GB")
    void testPattern() {
        BigDecimalValidator validator = CurrencyValidator.getInstance();
        String basicPattern = "\u00a4#,##0.000";
        String pattern = "\u00a4#,##0.000;[\u00a4#,##0.000]";
        BigDecimal expected = new BigDecimal("1234.567");
        BigDecimal negative = new BigDecimal("-1234.567");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.ukPound + "1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"default");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("[" + this.ukPound + "1,234.567]", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"negative");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"no symbol +ve");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("[1,234.567]", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"no symbol -ve");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.usDollar + "1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"default");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("[" + this.usDollar + "1,234.567]", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"negative");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"no symbol +ve");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("[1,234.567]", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"no symbol -ve");
        Assertions.assertFalse((boolean)validator.isValid(this.usDollar + "1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"invalid symbol");
        Assertions.assertFalse((boolean)validator.isValid(this.ukPound + "1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"invalid symbol");
    }

    @Test
    @DefaultLocale(value="en-GB")
    void testValid() {
        BigDecimalValidator validator = CurrencyValidator.getInstance();
        BigDecimal expected = new BigDecimal("1234.56");
        BigDecimal negative = new BigDecimal("-1234.56");
        BigDecimal noDecimal = new BigDecimal("1234.00");
        BigDecimal oneDecimal = new BigDecimal("1234.50");
        String ukPlus = NumberFormat.getCurrencyInstance(Locale.UK).format(1234.56);
        String ukPlus0Decimal = NumberFormat.getCurrencyInstance(Locale.UK).format(1234L);
        String ukPlus1Decimal = NumberFormat.getCurrencyInstance(Locale.UK).format(1234.5);
        String ukPlus3Decimal = NumberFormat.getCurrencyInstance(Locale.UK).format(1234.56) + "7";
        String ukMinus = NumberFormat.getCurrencyInstance(Locale.UK).format(-1234.56);
        String usPlus = NumberFormat.getCurrencyInstance(Locale.US).format(1234.56);
        String usPlus0Decimal = NumberFormat.getCurrencyInstance(Locale.US).format(1234L);
        String usPlus1Decimal = NumberFormat.getCurrencyInstance(Locale.US).format(1234.5);
        String usPlus3Decimal = NumberFormat.getCurrencyInstance(Locale.US).format(1234.56) + "7";
        String usMinus = NumberFormat.getCurrencyInstance(Locale.US).format(-1234.56);
        Assertions.assertEquals((Object)expected, (Object)validator.validate(ukPlus), (String)"Default locale");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(ukPlus, Locale.UK), (String)"UK locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate(ukMinus, Locale.UK), (String)"UK negative");
        Assertions.assertEquals((Object)noDecimal, (Object)validator.validate(ukPlus0Decimal, Locale.UK), (String)"UK no decimal");
        Assertions.assertEquals((Object)oneDecimal, (Object)validator.validate(ukPlus1Decimal, Locale.UK), (String)"UK 1 decimal");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(ukPlus3Decimal, Locale.UK), (String)("UK 3 decimal: " + ukPlus3Decimal));
        Assertions.assertEquals((Object)expected, (Object)validator.validate(ukPlus3Decimal, Locale.UK), (String)("UK 3 decimal: " + ukPlus3Decimal));
        Assertions.assertEquals((Object)expected, (Object)validator.validate("1,234.56", Locale.UK), (String)"UK no symbol");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(usPlus, Locale.US), (String)"US locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate(usMinus, Locale.US), (String)"US negative");
        Assertions.assertEquals((Object)noDecimal, (Object)validator.validate(usPlus0Decimal, Locale.US), (String)"US no decimal");
        Assertions.assertEquals((Object)oneDecimal, (Object)validator.validate(usPlus1Decimal, Locale.US), (String)"US 1 decimal");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(usPlus3Decimal, Locale.US), (String)("US 3 decimal: " + usPlus3Decimal));
        Assertions.assertEquals((Object)expected, (Object)validator.validate("1,234.56", Locale.US), (String)"US no symbol");
    }
}

