/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.descriptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.vintage.engine.descriptor.OrFilter;
import org.junit.vintage.engine.descriptor.RunnerDecorator;
import org.junit.vintage.engine.descriptor.RunnerRequest;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;

@API(status=API.Status.INTERNAL, since="4.12")
public class RunnerTestDescriptor
extends VintageTestDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(RunnerTestDescriptor.class);
    private final Set<Description> rejectedExclusions = new HashSet<Description>();
    private Runner runner;
    private final boolean ignored;
    private boolean wasFiltered;
    private List<Filter> filters = new ArrayList<Filter>();

    public RunnerTestDescriptor(UniqueId uniqueId, Class<?> testClass, Runner runner, boolean ignored) {
        super(uniqueId, runner.getDescription(), testClass.getSimpleName(), ClassSource.from(testClass));
        this.runner = runner;
        this.ignored = ignored;
    }

    @Override
    public String getLegacyReportingName() {
        return this.getSource().map(source -> ((ClassSource)source).getClassName()).orElseThrow(() -> new JUnitException("source should have been present"));
    }

    public Request toRequest() {
        return new RunnerRequest(this.runner);
    }

    @Override
    protected boolean tryToExcludeFromRunner(Description description) {
        boolean excluded = this.tryToFilterRunner(description);
        if (excluded) {
            this.wasFiltered = true;
        } else {
            this.rejectedExclusions.add(description);
        }
        return excluded;
    }

    private boolean tryToFilterRunner(Description description) {
        if (this.runner instanceof Filterable) {
            ExcludeDescriptionFilter filter = new ExcludeDescriptionFilter(description);
            try {
                ((Filterable)((Object)this.runner)).filter(filter);
            }
            catch (NoTestsRemainException noTestsRemainException) {
                // empty catch block
            }
            return filter.wasSuccessful();
        }
        return false;
    }

    @Override
    protected boolean canBeRemovedFromHierarchy() {
        return true;
    }

    @Override
    public void prune() {
        if (this.wasFiltered) {
            this.pruneDescriptorsForObsoleteDescriptions(Collections.singletonList(this.runner.getDescription()));
        }
        if (this.rejectedExclusions.isEmpty()) {
            super.prune();
        } else if (this.rejectedExclusions.containsAll(this.getDescription().getChildren())) {
            this.removeFromHierarchy();
        } else {
            this.logIncompleteFiltering();
        }
    }

    private void logIncompleteFiltering() {
        if (this.runner instanceof Filterable) {
            logger.warn(() -> "Runner " + this.getRunnerToReport().getClass().getName() + " (used on class " + this.getLegacyReportingName() + ") was not able to satisfy all filter requests.");
        } else {
            this.warnAboutUnfilterableRunner();
        }
    }

    private void warnAboutUnfilterableRunner() {
        logger.warn(() -> "Runner " + this.getRunnerToReport().getClass().getName() + " (used on class " + this.getLegacyReportingName() + ") does not support filtering and will therefore be run completely.");
    }

    public Optional<List<Filter>> getFilters() {
        return Optional.ofNullable(this.filters);
    }

    public void clearFilters() {
        this.filters = null;
    }

    public void applyFilters(Consumer<RunnerTestDescriptor> childrenCreator) {
        if (this.filters != null && !this.filters.isEmpty()) {
            if (this.runner instanceof Filterable) {
                this.runner = this.toRequest().filterWith(new OrFilter(this.filters)).getRunner();
                this.description = this.runner.getDescription();
                this.children.clear();
                childrenCreator.accept(this);
            } else {
                this.warnAboutUnfilterableRunner();
            }
        }
        this.clearFilters();
    }

    private Runner getRunnerToReport() {
        return this.runner instanceof RunnerDecorator ? ((RunnerDecorator)((Object)this.runner)).getDecoratedRunner() : this.runner;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    private static class ExcludeDescriptionFilter
    extends Filter {
        private final Description description;
        private boolean successful;

        ExcludeDescriptionFilter(Description description) {
            this.description = description;
        }

        @Override
        public boolean shouldRun(Description description) {
            if (this.description.equals(description)) {
                this.successful = true;
                return false;
            }
            return true;
        }

        @Override
        public String describe() {
            return "exclude " + this.description;
        }

        boolean wasSuccessful() {
            return this.successful;
        }
    }
}

