/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.BufferHelper;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class DivertConfiguration
implements Serializable,
EncodingSupport {
    private static final long serialVersionUID = 6910543740464269629L;
    public static String NAME = "name";
    public static String ROUTING_NAME = "routing-name";
    public static String ADDRESS = "address";
    public static String FORWARDING_ADDRESS = "forwarding-address";
    public static String EXCLUSIVE = "exclusive";
    public static String FILTER_STRING = "filter-string";
    public static String TRANSFORMER_CONFIGURATION = "transformer-configuration";
    public static String ROUTING_TYPE = "routing-type";
    private String name = null;
    private String routingName = UUIDGenerator.getInstance().generateStringUUID();
    private String address = null;
    private String forwardingAddress = null;
    private boolean exclusive = ActiveMQDefaultConfiguration.isDefaultDivertExclusive();
    private String filterString = null;
    private TransformerConfiguration transformerConfiguration = null;
    private ComponentConfigurationRoutingType routingType = ComponentConfigurationRoutingType.valueOf((String)ActiveMQDefaultConfiguration.getDefaultDivertRoutingType());

    public DivertConfiguration set(String key, String value) {
        if (key != null) {
            if (key.equals(NAME)) {
                this.setName(value);
            } else if (key.equals(ROUTING_NAME)) {
                this.setRoutingName(value);
            } else if (key.equals(ADDRESS)) {
                this.setAddress(value);
            } else if (key.equals(FORWARDING_ADDRESS)) {
                this.setForwardingAddress(value);
            } else if (key.equals(EXCLUSIVE)) {
                this.setExclusive(Boolean.parseBoolean(value));
            } else if (key.equals(FILTER_STRING)) {
                this.setFilterString(value);
            } else if (key.equals(TRANSFORMER_CONFIGURATION)) {
                TransformerConfiguration transformerConfiguration = TransformerConfiguration.fromJSON((String)value);
                if (transformerConfiguration != null) {
                    this.setTransformerConfiguration(transformerConfiguration);
                }
            } else if (key.equals(ROUTING_TYPE)) {
                this.setRoutingType(ComponentConfigurationRoutingType.valueOf((String)value));
            }
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getRoutingName() {
        return this.routingName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfiguration;
    }

    public ComponentConfigurationRoutingType getRoutingType() {
        return this.routingType;
    }

    public DivertConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public DivertConfiguration setRoutingName(String routingName) {
        this.routingName = routingName == null ? UUIDGenerator.getInstance().generateStringUUID() : routingName;
        return this;
    }

    public DivertConfiguration setAddress(String address) {
        this.address = address;
        return this;
    }

    public DivertConfiguration setForwardingAddress(String forwardingAddress) {
        this.forwardingAddress = forwardingAddress;
        return this;
    }

    public DivertConfiguration setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public DivertConfiguration setFilterString(String filterString) {
        this.filterString = filterString;
        return this;
    }

    public DivertConfiguration setTransformerConfiguration(TransformerConfiguration transformerConfiguration) {
        this.transformerConfiguration = transformerConfiguration;
        return this;
    }

    public DivertConfiguration setRoutingType(ComponentConfigurationRoutingType routingType) {
        this.routingType = routingType;
        return this;
    }

    public String toJSON() {
        TransformerConfiguration tc;
        JsonObjectBuilder builder = JsonLoader.createObjectBuilder();
        if (this.getName() != null) {
            builder.add(NAME, this.getName());
        }
        if (this.getRoutingName() != null) {
            builder.add(ROUTING_NAME, this.getRoutingName());
        }
        if (this.getAddress() != null) {
            builder.add(ADDRESS, this.getAddress());
        }
        if (this.getForwardingAddress() != null) {
            builder.add(FORWARDING_ADDRESS, this.getForwardingAddress());
        }
        builder.add(EXCLUSIVE, this.isExclusive());
        if (this.getFilterString() != null) {
            builder.add(FILTER_STRING, this.getFilterString());
        }
        if ((tc = this.getTransformerConfiguration()) != null) {
            builder.add(TRANSFORMER_CONFIGURATION, tc.createJsonObjectBuilder());
        }
        if (this.getRoutingType() != null) {
            builder.add(ROUTING_TYPE, this.getRoutingType().name());
        }
        return builder.build().toString();
    }

    public static DivertConfiguration fromJSON(String jsonString) {
        JsonObject json = JsonLoader.readObject((Reader)new StringReader(jsonString));
        DivertConfiguration result = new DivertConfiguration();
        for (Map.Entry entry : json.entrySet()) {
            if (((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                result.set((String)entry.getKey(), ((JsonString)entry.getValue()).getString());
                continue;
            }
            if (((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.NULL) {
                result.set((String)entry.getKey(), null);
                continue;
            }
            result.set((String)entry.getKey(), ((JsonValue)entry.getValue()).toString());
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.exclusive, this.filterString, this.forwardingAddress, this.name, this.routingName, this.transformerConfiguration, this.routingType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DivertConfiguration)) {
            return false;
        }
        DivertConfiguration other = (DivertConfiguration)obj;
        return Objects.equals(this.address, other.address) && this.exclusive == other.exclusive && Objects.equals(this.filterString, other.filterString) && Objects.equals(this.forwardingAddress, other.forwardingAddress) && Objects.equals(this.name, other.name) && Objects.equals(this.routingName, other.routingName) && Objects.equals(this.transformerConfiguration, other.transformerConfiguration) && Objects.equals(this.routingType, other.routingType);
    }

    public int getEncodeSize() {
        int transformerSize;
        if (this.transformerConfiguration != null) {
            transformerSize = BufferHelper.sizeOfNullableString((String)this.transformerConfiguration.getClassName());
            transformerSize += 4;
            for (Map.Entry entry : this.transformerConfiguration.getProperties().entrySet()) {
                transformerSize += BufferHelper.sizeOfNullableString((String)((String)entry.getKey()));
                transformerSize += BufferHelper.sizeOfNullableString((String)((String)entry.getValue()));
            }
        } else {
            transformerSize = 1;
        }
        int size = BufferHelper.sizeOfNullableString((String)this.name) + BufferHelper.sizeOfNullableString((String)this.address) + BufferHelper.sizeOfNullableString((String)this.forwardingAddress) + BufferHelper.sizeOfNullableString((String)this.routingName) + 1 + BufferHelper.sizeOfNullableString((String)this.filterString) + 1 + transformerSize;
        return size;
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeNullableString(this.name);
        buffer.writeNullableString(this.address);
        buffer.writeNullableString(this.forwardingAddress);
        buffer.writeNullableString(this.routingName);
        buffer.writeBoolean(this.exclusive);
        buffer.writeNullableString(this.filterString);
        buffer.writeByte(this.routingType != null ? this.routingType.getType() : ComponentConfigurationRoutingType.valueOf((String)ActiveMQDefaultConfiguration.getDefaultDivertRoutingType()).getType());
        if (this.transformerConfiguration != null) {
            buffer.writeNullableString(this.transformerConfiguration.getClassName());
            Map properties = this.transformerConfiguration.getProperties();
            buffer.writeInt(properties.size());
            for (Map.Entry entry : properties.entrySet()) {
                buffer.writeNullableString((String)entry.getKey());
                buffer.writeNullableString((String)entry.getValue());
            }
        } else {
            buffer.writeNullableString(null);
        }
    }

    public String toString() {
        return "DivertConfiguration [name=" + this.name + ", routingName=" + this.routingName + ", address=" + this.address + ", forwardingAddress=" + this.forwardingAddress + ", exclusive=" + this.exclusive + ", filterString=" + this.filterString + ", routing-type=" + String.valueOf(this.routingType) + ", transformerConfiguration=" + String.valueOf(this.transformerConfiguration) + "]";
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readNullableString();
        this.address = buffer.readNullableString();
        this.forwardingAddress = buffer.readNullableString();
        this.routingName = buffer.readNullableString();
        this.exclusive = buffer.readBoolean();
        this.filterString = buffer.readNullableString();
        this.routingType = ComponentConfigurationRoutingType.getType((byte)buffer.readByte());
        String transformerClassName = buffer.readNullableString();
        if (transformerClassName != null) {
            this.transformerConfiguration = new TransformerConfiguration(transformerClassName);
            int propsSize = buffer.readInt();
            for (int i = 0; i < propsSize; ++i) {
                this.transformerConfiguration.getProperties().put(buffer.readNullableString(), buffer.readNullableString());
            }
        }
    }
}

