/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;

public class CursorAckRecordEncoding
implements EncodingSupport {
    public long queueID;
    public PagePosition position;

    public CursorAckRecordEncoding(long queueID, PagePosition position) {
        this.queueID = queueID;
        this.position = position;
    }

    public CursorAckRecordEncoding() {
    }

    public String toString() {
        return "CursorAckRecordEncoding [queueID=" + this.queueID + ", position=" + String.valueOf(this.position) + "]";
    }

    public int getEncodeSize() {
        return 20;
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.queueID);
        buffer.writeLong(this.position.getPageNr());
        buffer.writeInt(this.position.getMessageNr());
    }

    public void decode(ActiveMQBuffer buffer) {
        this.queueID = buffer.readLong();
        long pageNR = buffer.readLong();
        int messageNR = buffer.readInt();
        this.position = new PagePositionImpl(pageNR, messageNR);
    }
}

