/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DerbyNetAutoStartTest
extends BaseJDBCTestCase {
    private Locale oldLocale = Locale.getDefault();
    private static boolean WITHOUTPORT = false;
    private static boolean WITHPORT = true;

    public DerbyNetAutoStartTest(String string) {
        super(string);
    }

    public void setUp() {
        TestConfiguration.getCurrent().shutdownEngine();
    }

    public void testStartNetworkServerFalse() throws Exception {
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.startNetworkServer", "false");
        this.getConnection();
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        DerbyNetAutoStartTest.assertFalse((boolean)NetworkServerTestSetup.pingForServerUp(networkServerControl, null, false));
    }

    public void ttestStartNetworkServerTrueNoPort() throws Exception {
        this.startNetworkServerTrueHelper(WITHOUTPORT);
    }

    public void testStartNetworkServerTrueWithPort() throws Exception {
        this.startNetworkServerTrueHelper(WITHPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartNetworkServerTrueWithInvalidPort() throws Exception {
        DatabaseMetaData databaseMetaData;
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.startNetworkServer", "true");
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.portNumber", "-1");
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream3 = new PrintStream(byteArrayOutputStream);
        DerbyNetAutoStartTest.setSystemOut(new PrintStream(printStream3));
        DerbyNetAutoStartTest.setSystemErr(new PrintStream(printStream3));
        try {
            try {
                databaseMetaData = this.getConnection().getMetaData();
                ResultSet resultSet = databaseMetaData.getSchemas();
                DerbyNetAutoStartTest.assertNotNull((Object)resultSet);
                resultSet.close();
            }
            catch (SQLException sQLException) {
                DerbyNetAutoStartTest.fail();
            }
        }
        finally {
            DerbyNetAutoStartTest.setSystemOut(printStream);
            DerbyNetAutoStartTest.setSystemErr(printStream2);
        }
        databaseMetaData = NetworkServerTestSetup.getNetworkServerControl();
        DerbyNetAutoStartTest.assertFalse((boolean)NetworkServerTestSetup.pingForServerUp((NetworkServerControl)databaseMetaData, null, false));
    }

    private void startNetworkServerTrueHelper(boolean bl) throws Exception {
        int n;
        if (bl) {
            n = TestConfiguration.getCurrent().getNextAvailablePort();
        } else {
            TestConfiguration.getCurrent();
            n = TestConfiguration.getBasePort();
        }
        int n2 = n;
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.startNetworkServer", "true");
        if (bl) {
            DerbyNetAutoStartTest.setSystemProperty("derby.drda.portNumber", Integer.toString(n2));
        }
        this.getConnection();
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl(n2);
        NetworkServerTestSetup.waitForServerStart(networkServerControl);
        networkServerControl.shutdown();
        DerbyNetAutoStartTest.assertFalse((boolean)NetworkServerTestSetup.pingForServerUp(networkServerControl, null, false));
    }

    public void testStartNetworkServerLogMessageOnDualStart() throws Exception {
        LocaleTestSetup.setDefaultLocale(Locale.ENGLISH);
        int n = TestConfiguration.getCurrent().getPort();
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl(n);
        networkServerControl.start(null);
        NetworkServerTestSetup.waitForServerStart(networkServerControl);
        TestConfiguration.getCurrent().shutdownEngine();
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.startNetworkServer", "true");
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.portNumber", Integer.toString(n));
        this.getConnection();
        DerbyNetAutoStartTest.assertTrue((boolean)NetworkServerTestSetup.pingForServerUp(networkServerControl, null, true));
        String string = DerbyNetAutoStartTest.getSystemProperty("derby.system.home") + File.separator + "derby.log";
        String string2 = "An exception was thrown during network server startup";
        long l = System.currentTimeMillis();
        long l2 = NetworkServerTestSetup.getWaitTime();
        while (true) {
            Thread.sleep(1000L);
            if (DerbyNetAutoStartTest.checkLog(string, new String[]{string2})) break;
            long l3 = System.currentTimeMillis() - l;
            if (l3 <= l2) continue;
            DerbyNetAutoStartTest.fail((String)("did not find the expected string: " + string2 + " within the maximum wait time " + l2));
        }
        DerbyNetAutoStartTest.assertTrue((boolean)DerbyNetAutoStartTest.checkLog(string, new String[]{string2}));
        networkServerControl.shutdown();
    }

    static boolean checkLog(String string, String[] stringArray) throws IOException {
        int n;
        String string2;
        boolean bl = true;
        boolean[] blArray = new boolean[stringArray.length];
        FileInputStream fileInputStream = PrivilegedFileOpsForTests.getFileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (blArray[n] || !string2.contains(stringArray[n])) continue;
                blArray[n] = true;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (blArray[n]) continue;
            bl = false;
        }
        bufferedReader.close();
        return bl;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DerbyNetAutoStartTest");
        baseTestSuite.addTest(DerbyNetAutoStartTest.baseSuite("DerbyNetAutoStartTest:embedded"));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        if (!Derby.hasServer()) {
            return baseTestSuite;
        }
        baseTestSuite.addTestSuite(DerbyNetAutoStartTest.class);
        if (DerbyNetAutoStartTest.getSystemProperty("derby.tests.basePort") != null) {
            return baseTestSuite;
        }
        baseTestSuite.addTest((Test)new DerbyNetAutoStartTest("ttestStartNetworkServerTrueNoPort"));
        return baseTestSuite;
    }

    @Override
    protected void tearDown() throws Exception {
        DerbyNetAutoStartTest.removeSystemProperty("derby.drda.startNetworkServer");
        DerbyNetAutoStartTest.removeSystemProperty("derby.drda.portNumber");
        LocaleTestSetup.setDefaultLocale(this.oldLocale);
        this.oldLocale = null;
        super.tearDown();
    }
}

