/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;

public class JitTest {
    public static void main(String[] args) {
        try {
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            System.out.println("Start JitTest");
            JitTest.testDerby1327BadStartWithForAutoIncColumn(conn);
            conn.close();
        }
        catch (Exception e) {
            System.out.println("FAIL -- unexpected exception " + String.valueOf(e));
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)e);
            e.printStackTrace(System.out);
        }
    }

    public static void testDerby1327BadStartWithForAutoIncColumn(Connection conn) throws Exception {
        conn.setAutoCommit(false);
        Statement stmt = null;
        JitTest.dropAllAppTables(conn);
        System.out.println("Create tables until we get a wrong Start with value");
        stmt = conn.createStatement();
        int numBadStartWith = 0;
        String createTableSQL = null;
        try {
            for (int i = 0; i < 200 && numBadStartWith == 0; ++i) {
                String tableName = "APP.MYTABLE" + i;
                createTableSQL = "CREATE TABLE " + tableName + "  (ROLEID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 2, INCREMENT BY 1), INSTANCEID INTEGER, STATUS INTEGER, LOGICAL_STATE INTEGER, LSTATE_TSTAMP  TIMESTAMP, UPDT_TSTAMP TIMESTAMP, TSTAMP TIMESTAMP, CLALEVEL1_CLALEVEL2_CLALEVEL2ID VARCHAR(255),  CLALEVEL1_CLALEVEL2_CLALEVEL3_CLALEVEL3ID VARCHAR(255))";
                stmt.executeUpdate(createTableSQL);
                conn.commit();
                numBadStartWith = JitTest.checkBadStartWithCols(conn, 2);
                if (numBadStartWith <= 0) {
                    continue;
                }
                break;
            }
        }
        catch (SQLException se) {
            System.out.println("Failed on " + createTableSQL);
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (numBadStartWith == 0) {
            System.out.println("PASS: All 200 tables created without problems");
            JitTest.dropAllAppTables(conn);
        }
        stmt.close();
        conn.rollback();
    }

    private static int checkBadStartWithCols(Connection conn, int maxautoincrementstart) throws Exception {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select count(autoincrementstart) from sys.syscolumns c, sys.systables t, sys.sysschemas s WHERE t.schemaid =  s.schemaid and CAST(s.schemaname AS VARCHAR(128))= 'APP' and autoincrementstart > " + maxautoincrementstart);
        rs.next();
        int numBadStartWith = rs.getInt(1);
        if (numBadStartWith > 0) {
            System.out.println(numBadStartWith + " columns have bad START WITH VALUE");
        }
        rs.close();
        if (numBadStartWith > 0) {
            rs = stmt.executeQuery("select tablename, columnname, autoincrementstart from sys.syscolumns c, sys.systables t, CAST(sys.sysschemas AS VARCHAR(128)) s WHERE t.schemaid = s.schemaid and CAST(s.schemaname AS VARCHAR(128)) = 'APP' and autoincrementstart > 2 ORDER BY tablename");
            while (rs.next()) {
                System.out.println("Unexpected start value: " + rs.getLong(3) + " on column " + rs.getString(1) + "(" + rs.getString(2) + ")");
            }
        }
        return numBadStartWith;
    }

    private static void dropAllAppTables(Connection conn) throws SQLException {
        Statement stmt1 = conn.createStatement();
        Statement stmt2 = conn.createStatement();
        System.out.println("Drop all tables in APP schema");
        ResultSet rs = stmt1.executeQuery("SELECT tablename from sys.systables t, sys.sysschemas s where t.schemaid = s.schemaid and CAST(s.schemaname AS VARCHAR(128)) = 'APP'");
        while (rs.next()) {
            String tableName = rs.getString(1);
            try {
                stmt2.executeUpdate("DROP TABLE " + tableName);
            }
            catch (SQLException se) {
                System.out.println("Error dropping table:" + tableName);
                se.printStackTrace();
            }
        }
    }
}

