/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.derbyTesting.functionTests.tests.memorydb.ClusMog;
import org.apache.derbyTesting.junit.BaseTestCase;

public class ClusMogSQL
extends ClusMog {
    Connection conn;
    int uniq = 0;

    public ClusMogSQL(Connection connection) {
        this.conn = connection;
    }

    public void setUnique(int n) {
        this.uniq = n & Integer.MAX_VALUE;
    }

    public void clusterSQL(int n, double[] dArray, int n2, double[] dArray2) throws SQLException {
        this.setCenters(n, dArray);
        this.setSamples(n2, dArray2);
        this.init();
        double d = Double.MAX_VALUE;
        int n3 = 1;
        while (true) {
            double d2 = this.expect();
            this.maximize();
            double d3 = Math.abs(d2 - d);
            double d4 = d3 / (1.0 + d);
            d = d2;
            if (d4 < 1.0E-6) break;
            ++n3;
        }
        this.download();
        this.cleanup();
        this.printMog("SQL-COMPUTED", n, this.weight, this.mean, this.var);
        BaseTestCase.println("msr = (" + d + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws SQLException {
        Arrays.sort(this.sample, 0, this.ns);
        Arrays.sort(this.mean, 0, this.n);
        String string = "cluster" + this.uniq;
        String string2 = "sample" + this.uniq;
        Statement statement = null;
        Statement statement2 = this.conn.createStatement();
        try {
            double d;
            int n;
            statement2.executeUpdate("CREATE TABLE " + string + "(weight double, mean double, var double, bucket int PRIMARY KEY)");
            statement2.executeUpdate("CREATE TABLE " + string2 + "(value double, id int PRIMARY KEY, bucket int)");
            statement = this.conn.prepareStatement("INSERT INTO " + string2 + "(value, id) VALUES (?, ?)");
            for (n = 0; n < this.ns; ++n) {
                d = this.sample[n];
                statement.setDouble(1, d);
                statement.setInt(2, n);
                statement.executeUpdate();
            }
            statement.close();
            statement = this.conn.prepareStatement("INSERT INTO " + string + "(mean, bucket) VALUES (?, ?)");
            for (n = 0; n < this.n; ++n) {
                d = this.mean[n];
                statement.setDouble(1, d);
                statement.setInt(2, n);
                statement.executeUpdate();
            }
        }
        finally {
            if (statement2 != null) {
                statement2.close();
                statement2 = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
        this.maximize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double expect() throws SQLException {
        String string = "cluster" + this.uniq;
        String string2 = "sample" + this.uniq;
        String string3 = "mm" + this.uniq;
        String string4 = "vv" + this.uniq;
        String string5 = "ee" + this.uniq;
        double d = Double.MAX_VALUE;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.createStatement();
            statement.executeUpdate("CREATE TABLE " + string3 + "(bucket int PRIMARY KEY, mean double)");
            statement.executeUpdate("CREATE TABLE " + string4 + "(bucket int PRIMARY KEY, var double)");
            statement.executeUpdate("CREATE TABLE " + string5 + "(bucket int PRIMARY KEY, err double, size int)");
            statement.executeUpdate("INSERT INTO " + string3 + "(bucket, mean) \nSELECT bucket, avg(value) \n  FROM " + string2 + " \n GROUP BY bucket \n");
            statement.executeUpdate("INSERT INTO " + string5 + "(bucket, err, size) \nSELECT S.bucket, sum((S.value - M.mean) * (S.value - M.mean)), count(*) \n  FROM " + string2 + " S JOIN " + string3 + " M ON S.bucket = M.bucket \n GROUP BY S.bucket \n");
            statement.executeUpdate("INSERT INTO " + string4 + "(bucket, var) \nSELECT bucket, \n       CASE WHEN (size > 1) THEN (err / (size - 1)) ELSE 0.0 END \n  FROM " + string5 + " \n");
            statement.executeUpdate("DELETE FROM " + string);
            statement.executeUpdate("INSERT INTO " + string + "(mean, var, bucket) \nSELECT M.mean, V.var, V.bucket \n  FROM " + string3 + " M JOIN " + string4 + " V ON M.bucket = V.bucket \n");
            resultSet = statement.executeQuery("SELECT (sum(err) / sum(size)) AS measure FROM " + string5);
            while (resultSet.next()) {
                d = resultSet.getDouble(1);
            }
            statement.executeUpdate("DROP TABLE " + string3);
            statement.executeUpdate("DROP TABLE " + string4);
            statement.executeUpdate("DROP TABLE " + string5);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maximize() throws SQLException {
        String string = "cluster" + this.uniq;
        String string2 = "sample" + this.uniq;
        String string3 = "gg" + this.uniq;
        String string4 = "jj" + this.uniq;
        try (Statement statement = null;){
            statement = this.conn.createStatement();
            statement.executeUpdate("CREATE TABLE " + string3 + "(id int PRIMARY KEY, diff double)");
            statement.executeUpdate("CREATE TABLE " + string4 + "(value double, id int, diff double, bucket int)");
            statement.executeUpdate("INSERT INTO " + string3 + "(id, diff) \nSELECT S.id, min(abs(S.value - C.mean)) \n  FROM " + string2 + " S, " + string + " C \n GROUP BY S.id \n");
            statement.executeUpdate("INSERT INTO " + string4 + "(value, id, diff, bucket) \nSELECT S.value, S.id, abs(S.value - C.mean), C.bucket \n  FROM " + string2 + " S, " + string + " C \n");
            statement.executeUpdate("DELETE FROM " + string2);
            statement.executeUpdate("INSERT INTO " + string2 + "(value, id, bucket) \nSELECT J.value, J.id, min(J.bucket) \n  FROM " + string4 + " J \n  JOIN " + string3 + " G \n    ON J.id   = G.id \n   AND J.diff = G.diff \n GROUP BY J.id, J.value \n");
            statement.executeUpdate("DROP TABLE " + string3);
            statement.executeUpdate("DROP TABLE " + string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void download() throws SQLException {
        String string = "cluster" + this.uniq;
        String string2 = "sample" + this.uniq;
        String string3 = "ww" + this.uniq;
        String string4 = "cc" + this.uniq;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.createStatement();
            statement.executeUpdate("CREATE TABLE " + string3 + "(bucket int PRIMARY KEY, size int)");
            statement.executeUpdate("CREATE TABLE " + string4 + "(weight double, mean double, var double, bucket int PRIMARY KEY)");
            statement.executeUpdate("INSERT INTO " + string3 + "(bucket, size) \nSELECT bucket, count(*) \n  FROM " + string2 + " \n GROUP BY bucket \n");
            statement.executeUpdate("INSERT INTO " + string4 + "(weight, mean, var, bucket) \nSELECT (CAST(W.size AS double) / (SELECT sum(size) FROM " + string3 + ")), C.mean, C.var, C.bucket \n  FROM " + string + " C JOIN " + string3 + " W ON C.bucket = W.bucket \n");
            statement.executeUpdate("DELETE FROM " + string);
            statement.executeUpdate("INSERT INTO " + string + "(weight, mean, var, bucket) \nSELECT weight, mean, var, bucket FROM " + string4 + " \n");
            statement.executeUpdate("DROP TABLE " + string3);
            statement.executeUpdate("DROP TABLE " + string4);
            resultSet = statement.executeQuery("SELECT weight, mean, var FROM " + string + " ORDER BY mean");
            this.n = 0;
            while (resultSet.next()) {
                double d = resultSet.getDouble(1);
                double d2 = resultSet.getDouble(2);
                double d3 = resultSet.getDouble(3);
                this.weight[this.n] = d;
                this.mean[this.n] = d2;
                this.var[this.n] = d3;
                ++this.n;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() throws SQLException {
        String string = "cluster" + this.uniq;
        String string2 = "sample" + this.uniq;
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            statement.executeUpdate("DROP TABLE " + string2);
            statement.executeUpdate("DROP TABLE " + string);
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
    }
}

