package org.apache.torque.ant.task;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;

import junit.framework.TestCase;

import org.apache.commons.io.FileUtils;

public class TorqueGeneratorTaskTest extends TestCase
{
    public void testExecute() throws Exception
    {
        File target = new File("target/tests/torqueGeneratorTaskTest");
        FileUtils.deleteDirectory(target);
        TorqueGeneratorTask task = new TorqueGeneratorTask();
        task.setPackaging("directory");
        task.setProjectRootDir(new File("src/test/torqueGeneratorTaskTest"));
        task.setDefaultOutputDir(target);
        task.execute();

        assertTrue(target.exists());
        File generatedJavaFile = new File(
                target,
                "org/apache/torque/ant/PropertyKeys.java");
        assertTrue(generatedJavaFile.exists());
        File expectedJavaFile = new File(
                "src/test/resources/org/apache/torque/ant/PropertyKeys.java");
        junitx.framework.FileAssert.assertEquals(
                expectedJavaFile,
                generatedJavaFile);
    }
}
