// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.agg;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.functions.Function;
import org.apache.doris.nereids.trees.expressions.literal.BigIntLiteral;
import org.apache.doris.nereids.trees.expressions.shape.UnaryExpression;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.BigIntType;
import org.apache.doris.nereids.types.DataType;
import org.apache.doris.nereids.types.HllType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * AggregateFunction 'hll_union_agg'. This class is generated by GenerateFunction.
 */
public class HllUnionAgg extends NotNullableAggregateFunction
        implements UnaryExpression, ExplicitlyCastableSignature, HllFunction, RollUpTrait {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.ret(BigIntType.INSTANCE).args(HllType.INSTANCE)
    );

    /**
     * constructor with 1 argument.
     */
    public HllUnionAgg(Expression arg) {
        super("hll_union_agg", arg);
    }

    /**
     * constructor with 1 argument.
     */
    public HllUnionAgg(boolean distinct, Expression arg) {
        this(arg);
    }

    /** constructor for withChildren and reuse signature */
    protected HllUnionAgg(AggregateFunctionParams functionParams) {
        super(functionParams);
    }

    @Override
    protected List<DataType> intermediateTypes() {
        return ImmutableList.of(HllType.INSTANCE);
    }

    /**
     * withDistinctAndChildren.
     */
    @Override
    public HllUnionAgg withDistinctAndChildren(boolean distinct, List<Expression> children) {
        Preconditions.checkArgument(children.size() == 1);
        return new HllUnionAgg(getFunctionParams(distinct, children));
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitHllUnionAgg(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }

    @Override
    public Function constructRollUp(Expression param, Expression... varParams) {
        return new HllUnionAgg(getFunctionParams(ImmutableList.of(param)));
    }

    @Override
    public boolean canRollUp() {
        return false;
    }

    @Override
    public Expression resultForEmptyInput() {
        return new BigIntLiteral(0);
    }
}
