/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.scheduledbatch;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.scheduledbatch.CronSchedulerConfig;
import org.apache.druid.indexing.scheduledbatch.CronSchedulerUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class QuartzCronSchedulerConfig
implements CronSchedulerConfig {
    public static final String TYPE = "quartz";
    private static final CronParser QUARTZ_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    @JsonProperty
    private final String schedule;
    private final ExecutionTime executionTime;

    @JsonCreator
    public QuartzCronSchedulerConfig(@JsonProperty(value="schedule") String schedule) {
        try {
            this.executionTime = ExecutionTime.forCron((Cron)QUARTZ_PARSER.parse(schedule));
            this.schedule = schedule;
        }
        catch (IllegalArgumentException e) {
            throw InvalidInput.exception((String)"Quartz schedule[%s] is invalid: [%s]", (Object[])new Object[]{schedule, e.getMessage()});
        }
    }

    @Override
    @Nullable
    public DateTime getNextTaskStartTimeAfter(DateTime referenceTime) {
        return CronSchedulerUtils.getNextTaskStartTimeAfter(this.executionTime, referenceTime);
    }

    @Override
    @Nullable
    public Duration getDurationUntilNextTaskStartTimeAfter(DateTime referenceTime) {
        return CronSchedulerUtils.getDurationUntilNextTaskStartTimeAfter(this.executionTime, referenceTime);
    }

    public String toString() {
        return "QuartzCronSchedulerConfig{schedule='" + this.schedule + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuartzCronSchedulerConfig that = (QuartzCronSchedulerConfig)o;
        return Objects.equals(this.schedule, that.schedule);
    }

    public int hashCode() {
        return Objects.hash(this.schedule);
    }
}

