/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.scheduledbatch;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.scheduledbatch.CronSchedulerConfig;
import org.apache.druid.indexing.scheduledbatch.CronSchedulerUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class UnixCronSchedulerConfig
implements CronSchedulerConfig {
    public static final String TYPE = "unix";
    private static final CronParser UNIX_PARSER = UnixCronSchedulerConfig.createUnixCronParserWithMacros();
    private final ExecutionTime executionTime;
    @JsonProperty
    private final String schedule;

    private static CronParser createUnixCronParserWithMacros() {
        CronDefinitionBuilder unixDefnWithMacros = CronDefinitionBuilder.defineCron();
        CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX).getFieldDefinitions().forEach(arg_0 -> ((CronDefinitionBuilder)unixDefnWithMacros).register(arg_0));
        return new CronParser(unixDefnWithMacros.withSupportedNicknameHourly().withSupportedNicknameMidnight().withSupportedNicknameDaily().withSupportedNicknameWeekly().withSupportedNicknameMonthly().withSupportedNicknameAnnually().withSupportedNicknameYearly().instance());
    }

    @JsonCreator
    public UnixCronSchedulerConfig(@JsonProperty(value="schedule") String schedule) {
        try {
            this.executionTime = ExecutionTime.forCron((Cron)UNIX_PARSER.parse(schedule));
            this.schedule = schedule;
        }
        catch (IllegalArgumentException e) {
            throw InvalidInput.exception((String)"Unix schedule[%s] is invalid: [%s]", (Object[])new Object[]{schedule, e.getMessage()});
        }
    }

    @Override
    @Nullable
    public DateTime getNextTaskStartTimeAfter(DateTime referenceTime) {
        return CronSchedulerUtils.getNextTaskStartTimeAfter(this.executionTime, referenceTime);
    }

    @Override
    @Nullable
    public Duration getDurationUntilNextTaskStartTimeAfter(DateTime referenceTime) {
        return CronSchedulerUtils.getDurationUntilNextTaskStartTimeAfter(this.executionTime, referenceTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnixCronSchedulerConfig that = (UnixCronSchedulerConfig)o;
        return Objects.equals(this.schedule, that.schedule);
    }

    public int hashCode() {
        return Objects.hash(this.schedule);
    }

    public String toString() {
        return "UnixCronSchedulerConfig{schedule='" + this.schedule + "'}";
    }
}

