/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.util.Callback;

public class SessionHandler
extends AbstractSessionManager
implements Handler.Singleton {
    private Server _server;
    private Handler _handler;

    public void setServer(Server server) {
        this._server = server;
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.setServer(server);
        }
    }

    public Handler getHandler() {
        return this._handler;
    }

    public void setHandler(Handler handler) {
        this._handler = Handler.Singleton.updateHandler((Handler.Singleton)this, (Handler)handler);
    }

    @Override
    public Server getServer() {
        return this._server;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        SessionRequest sessionRequest = new SessionRequest(request);
        this.addSessionStreamWrapper((Request)sessionRequest);
        return sessionRequest.process((Request.Handler)next, response, callback);
    }

    @Override
    public ManagedSession getManagedSession(Request request) {
        return (ManagedSession)Request.get((Request)request, SessionRequest.class, SessionRequest::getManagedSession);
    }

    @Override
    public Session.API newSessionAPIWrapper(ManagedSession session) {
        return null;
    }

    private class SessionRequest
    extends Request.Wrapper {
        private final AtomicReference<ManagedSession> _session;
        private String _requestedSessionId;
        private Response _response;

        public SessionRequest(Request request) {
            super(request);
            this._session = new AtomicReference();
        }

        void setManagedSession(ManagedSession session) {
            this._session.set(session);
        }

        ManagedSession getManagedSession() {
            return this._session.get();
        }

        public Session getSession(boolean create) {
            if (this._response == null) {
                throw new IllegalStateException("!processing");
            }
            ManagedSession session = this._session.get();
            if (session == null && create) {
                SessionHandler.this.newSession((Request)this, this._requestedSessionId, this::setManagedSession);
                session = this._session.get();
                HttpCookie cookie = SessionHandler.this.getSessionCookie(session, this.getConnectionMetaData().isSecure());
                if (cookie != null) {
                    Response.putCookie((Response)this._response, (HttpCookie)cookie);
                }
            }
            return session == null || !session.isValid() ? null : session;
        }

        public boolean process(Request.Handler handler, Response response, Callback callback) throws Exception {
            this._response = response;
            AbstractSessionManager.RequestedSession requestedSession = SessionHandler.this.resolveRequestedSessionId((Request)this);
            this._requestedSessionId = requestedSession.sessionId();
            ManagedSession session = requestedSession.session();
            if (session != null) {
                this._session.set(session);
                HttpCookie cookie = SessionHandler.this.access(session, this.getConnectionMetaData().isSecure());
                if (cookie != null) {
                    Response.putCookie((Response)this._response, (HttpCookie)cookie);
                }
            }
            return handler.handle((Request)this, this._response, callback);
        }
    }
}

