/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.SuperSorterProgressTracker;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterSnapshots;
import org.apache.druid.msq.counters.CpuCounter;
import org.apache.druid.msq.counters.CpuCounters;
import org.apache.druid.msq.counters.CpuTimeAccumulatingFrameProcessor;
import org.apache.druid.msq.counters.CpuTimeAccumulatingProcessorManager;
import org.apache.druid.msq.counters.QueryCounter;
import org.apache.druid.msq.counters.QueryCounterSnapshot;
import org.apache.druid.msq.counters.SegmentGenerationProgressCounter;
import org.apache.druid.msq.counters.SuperSorterProgressTrackerCounter;
import org.apache.druid.msq.counters.WarningCounters;
import org.apache.druid.utils.JvmUtils;

public class CounterTracker {
    private final ConcurrentHashMap<String, QueryCounter> countersMap = new ConcurrentHashMap();
    private final boolean includeAllCounters;

    public CounterTracker(boolean includeAllCounters) {
        this.includeAllCounters = includeAllCounters;
    }

    public ChannelCounters channel(String name) {
        return this.counter(name, ChannelCounters::new);
    }

    public CpuCounter cpu(String name) {
        return this.counter(CounterNames.cpu(), CpuCounters::new).forName(name);
    }

    public <T> FrameProcessor<T> trackCpu(FrameProcessor<T> processor, String name) {
        if (JvmUtils.isThreadCpuTimeEnabled()) {
            CpuCounter counter = this.counter(CounterNames.cpu(), CpuCounters::new).forName(name);
            return new CpuTimeAccumulatingFrameProcessor<T>(processor, counter);
        }
        return processor;
    }

    public <T, R> ProcessorManager<T, R> trackCpu(ProcessorManager<T, R> processorManager, String name) {
        if (JvmUtils.isThreadCpuTimeEnabled()) {
            CpuCounter counter = this.counter(CounterNames.cpu(), CpuCounters::new).forName(name);
            return new CpuTimeAccumulatingProcessorManager<T, R>(processorManager, counter);
        }
        return processorManager;
    }

    public SuperSorterProgressTracker sortProgress() {
        return this.counter(CounterNames.sortProgress(), SuperSorterProgressTrackerCounter::new).tracker();
    }

    public SegmentGenerationProgressCounter segmentGenerationProgress() {
        return this.counter(CounterNames.getSegmentGenerationProgress(), SegmentGenerationProgressCounter::new);
    }

    public WarningCounters warnings() {
        return this.counter(CounterNames.warnings(), WarningCounters::new);
    }

    public <T extends QueryCounter> T counter(String counterName, Supplier<T> newCounterFn) {
        return (T)this.countersMap.computeIfAbsent(counterName, ignored -> (QueryCounter)newCounterFn.get());
    }

    public long totalCpu() {
        if (!this.countersMap.containsKey(CounterNames.cpu())) {
            return 0L;
        }
        long cpuTimeNs = 0L;
        CpuCounters cpuCounters = (CpuCounters)this.countersMap.get(CounterNames.cpu());
        for (CpuCounter.Snapshot value : cpuCounters.snapshot().getCountersMap().values()) {
            cpuTimeNs += value.getCpuTime();
        }
        return cpuTimeNs;
    }

    public CounterSnapshots snapshot() {
        HashMap<String, QueryCounterSnapshot> m = new HashMap<String, QueryCounterSnapshot>();
        for (Map.Entry<String, QueryCounter> entry : this.countersMap.entrySet()) {
            QueryCounterSnapshot counterSnapshot = entry.getValue().snapshot();
            if (counterSnapshot == null || !this.includeAllCounters && !CounterTracker.isLegacyCounter(counterSnapshot)) continue;
            m.put(entry.getKey(), counterSnapshot);
        }
        return new CounterSnapshots(m);
    }

    private static boolean isLegacyCounter(QueryCounterSnapshot counterSnapshot) {
        return counterSnapshot instanceof ChannelCounters.Snapshot || counterSnapshot instanceof SuperSorterProgressTrackerCounter.Snapshot || counterSnapshot instanceof WarningCounters.Snapshot || counterSnapshot instanceof SegmentGenerationProgressCounter.Snapshot;
    }
}

