/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateIpamExternalResourceVerificationTokenRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateIpamExternalResourceVerificationTokenRequestMarshaller
implements Marshaller<Request<CreateIpamExternalResourceVerificationTokenRequest>, CreateIpamExternalResourceVerificationTokenRequest> {
    public Request<CreateIpamExternalResourceVerificationTokenRequest> marshall(CreateIpamExternalResourceVerificationTokenRequest createIpamExternalResourceVerificationTokenRequest) {
        SdkInternalList createIpamExternalResourceVerificationTokenRequestTagSpecificationsList;
        if (createIpamExternalResourceVerificationTokenRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createIpamExternalResourceVerificationTokenRequest, "AmazonEC2");
        request.addParameter("Action", "CreateIpamExternalResourceVerificationToken");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createIpamExternalResourceVerificationTokenRequest.getIpamId() != null) {
            request.addParameter("IpamId", StringUtils.fromString((String)createIpamExternalResourceVerificationTokenRequest.getIpamId()));
        }
        if (!(createIpamExternalResourceVerificationTokenRequestTagSpecificationsList = (SdkInternalList)createIpamExternalResourceVerificationTokenRequest.getTagSpecifications()).isEmpty() || !createIpamExternalResourceVerificationTokenRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createIpamExternalResourceVerificationTokenRequestTagSpecificationsListValue : createIpamExternalResourceVerificationTokenRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createIpamExternalResourceVerificationTokenRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createIpamExternalResourceVerificationTokenRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createIpamExternalResourceVerificationTokenRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createIpamExternalResourceVerificationTokenRequest.getClientToken()));
        return request;
    }
}

