/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.http.AbstractHttpClientProvider;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.server.DruidNode;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyHttpClientModule
implements Module {
    private final String propertyPrefix;
    private final Class<? extends Annotation> annotationClazz;

    public static JettyHttpClientModule global() {
        return new JettyHttpClientModule("druid.global.http", Global.class);
    }

    public JettyHttpClientModule(String propertyPrefix, Class<? extends Annotation> annotationClazz) {
        this.propertyPrefix = (String)Preconditions.checkNotNull((Object)propertyPrefix, (Object)"propertyPrefix");
        this.annotationClazz = (Class)Preconditions.checkNotNull(annotationClazz, (Object)"annotationClazz");
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class, this.annotationClazz);
        binder.bind(HttpClient.class).annotatedWith(this.annotationClazz).toProvider((Provider)new HttpClientProvider(this.annotationClazz)).in(LazySingleton.class);
    }

    public static class HttpClientProvider
    extends AbstractHttpClientProvider<HttpClient> {
        @Inject
        @Self
        private DruidNode node;

        public HttpClientProvider(Class<? extends Annotation> annotation) {
            super(annotation);
        }

        public HttpClient get() {
            HttpClient httpClient;
            DruidHttpClientConfig config = (DruidHttpClientConfig)((Supplier)this.getConfigProvider().get()).get();
            Binding<SSLContext> sslContextBinding = this.getSslContextBinding();
            if (sslContextBinding != null) {
                SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
                sslContextFactory.setSslContext((SSLContext)sslContextBinding.getProvider().get());
                ClientConnector clientConnector = new ClientConnector();
                clientConnector.setSslContextFactory(sslContextFactory);
                httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
            } else {
                httpClient = new HttpClient();
            }
            httpClient.setIdleTimeout(config.getReadTimeout().getMillis());
            httpClient.setMaxConnectionsPerDestination(config.getNumConnections());
            httpClient.setMaxRequestsQueuedPerDestination(config.getNumRequestsQueued());
            httpClient.setConnectTimeout(config.getClientConnectTimeout());
            httpClient.setRequestBufferSize(config.getRequestBuffersize());
            QueuedThreadPool pool = new QueuedThreadPool(config.getNumMaxThreads());
            pool.setName(JettyHttpClientModule.class.getSimpleName() + "-threadPool-" + pool.hashCode());
            httpClient.setExecutor((Executor)pool);
            httpClient.setUserAgentField(new HttpField("User-Agent", StringUtils.format((String)"%s/%s", (Object[])new Object[]{this.node.getServiceName(), this.node.getVersion()})));
            Lifecycle lifecycle = (Lifecycle)this.getLifecycleProvider().get();
            try {
                lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                    public void start() {
                    }

                    public void stop() {
                        try {
                            httpClient.stop();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return httpClient;
        }
    }
}

