/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CollectionUtils;

public class SegmentPublishResult {
    private final Set<DataSegment> segments;
    private final boolean success;
    private final boolean retryable;
    private final String errorMsg;
    private final List<PendingSegmentRecord> upgradedPendingSegments;

    public static SegmentPublishResult ok(Set<DataSegment> segments) {
        return new SegmentPublishResult(segments, true, false, null);
    }

    public static SegmentPublishResult ok(Set<DataSegment> segments, List<PendingSegmentRecord> upgradedPendingSegments) {
        return new SegmentPublishResult(segments, true, false, null, upgradedPendingSegments);
    }

    public static SegmentPublishResult fail(String errorMsg, Object ... args) {
        return new SegmentPublishResult(Set.of(), false, false, StringUtils.format((String)errorMsg, (Object[])args), null);
    }

    public static SegmentPublishResult retryableFailure(String errorMsg, Object ... args) {
        return new SegmentPublishResult(Set.of(), false, true, StringUtils.format((String)errorMsg, (Object[])args), null);
    }

    @JsonCreator
    private SegmentPublishResult(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="success") boolean success, @JsonProperty(value="retryable") boolean retryable, @JsonProperty(value="errorMsg") @Nullable String errorMsg) {
        this(segments, success, retryable, errorMsg, null);
    }

    private SegmentPublishResult(Set<DataSegment> segments, boolean success, boolean retryable, @Nullable String errorMsg, List<PendingSegmentRecord> upgradedPendingSegments) {
        this.segments = (Set)Preconditions.checkNotNull(segments, (Object)"segments");
        this.success = success;
        this.errorMsg = errorMsg;
        this.retryable = retryable;
        this.upgradedPendingSegments = upgradedPendingSegments;
        if (!success) {
            Preconditions.checkArgument((boolean)segments.isEmpty(), (Object)"segments must be empty for unsuccessful publishes");
            Preconditions.checkArgument((boolean)CollectionUtils.isNullOrEmpty(upgradedPendingSegments), (Object)"upgraded pending segments must be null or empty for unsuccessful publishes");
        }
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public boolean isSuccess() {
        return this.success;
    }

    @JsonProperty
    @Nullable
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @JsonProperty
    public boolean isRetryable() {
        return this.retryable;
    }

    @Nullable
    public List<PendingSegmentRecord> getUpgradedPendingSegments() {
        return this.upgradedPendingSegments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentPublishResult that = (SegmentPublishResult)o;
        return this.success == that.success && this.retryable == that.retryable && Objects.equals(this.segments, that.segments) && Objects.equals(this.errorMsg, that.errorMsg);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.success, this.errorMsg, this.retryable);
    }

    public String toString() {
        return "SegmentPublishResult{segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + ", success=" + this.success + ", retryable=" + this.retryable + ", errorMsg='" + this.errorMsg + "'}";
    }
}

