/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule.logical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.druid.error.DruidException;
import org.apache.druid.sql.calcite.rel.DruidCorrelateUnnestRel;
import org.apache.druid.sql.calcite.rule.logical.LogicalUnnest;

public class LogicalUnnestRule
extends RelOptRule
implements SubstitutionRule {
    public LogicalUnnestRule() {
        super(LogicalUnnestRule.operand(LogicalCorrelate.class, (RelOptRuleOperandChildren)LogicalUnnestRule.any()));
    }

    public boolean autoPruneOld() {
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalCorrelate cor = (LogicalCorrelate)call.rel(0);
        UnnestConfiguration unnestConfig = this.unwrapUnnestConfigurationExpression(cor.getRight().stripped());
        if (unnestConfig == null) {
            throw DruidException.defensive((String)"Couldn't process possible unnest for reltree: \n%s", (Object[])new Object[]{RelOptUtil.toString((RelNode)cor)});
        }
        unnestConfig = unnestConfig.withExpr(new DruidCorrelateUnnestRel.CorrelatedFieldAccessToInputRef(cor.getCorrelationId()).apply(unnestConfig.expr));
        RelDataTypeField unnestFieldType = (RelDataTypeField)Iterables.getLast((Iterable)cor.getRowType().getFieldList());
        RelBuilder builder = call.builder();
        builder.push(cor.getLeft());
        builder.push((RelNode)new LogicalUnnest(cor.getCluster(), cor.getTraitSet(), builder.build(), unnestConfig.expr, unnestFieldType, unnestConfig.condition));
        if (unnestConfig.discard) {
            ImmutableList fields = builder.fields();
            builder.project((Iterable)fields.subList(0, fields.size() - 1));
        }
        call.transformTo(builder.build());
    }

    private UnnestConfiguration unwrapUnnestConfigurationExpression(RelNode rel) {
        Filter filter;
        UnnestConfiguration conf;
        Project project;
        if ((rel = rel.stripped()) instanceof Project && (project = (Project)rel).getProjects().size() == 0) {
            return this.unwrapUnnestConfigurationExpression(project.getInput()).withDiscard();
        }
        if (rel instanceof Filter && (conf = this.unwrapUnnestConfigurationExpression((filter = (Filter)rel).getInput())) != null) {
            return conf.withFilter(filter.getCondition());
        }
        if (rel instanceof Uncollect) {
            Uncollect uncollect = (Uncollect)rel;
            if (!uncollect.withOrdinality) {
                return this.unwrapProjectExpression(uncollect.getInput());
            }
        }
        return null;
    }

    private UnnestConfiguration unwrapProjectExpression(RelNode rel) {
        Project project;
        if ((rel = rel.stripped()) instanceof Project && this.isValues((project = (Project)rel).getInput().stripped())) {
            return UnnestConfiguration.ofExpression((RexNode)Iterables.getOnlyElement((Iterable)project.getProjects()));
        }
        return null;
    }

    private boolean isValues(RelNode rel) {
        rel = rel.stripped();
        return rel instanceof LogicalValues;
    }

    private static class UnnestConfiguration {
        protected final RexNode expr;
        protected final RexNode condition;
        protected final boolean discard;

        public UnnestConfiguration(RexNode unnestExpression, RexNode condition, boolean discard) {
            this.expr = unnestExpression;
            this.condition = condition;
            this.discard = discard;
        }

        public UnnestConfiguration withExpr(RexNode expr) {
            return new UnnestConfiguration(expr, this.condition, this.discard);
        }

        public static UnnestConfiguration ofExpression(RexNode unnestExpression) {
            return new UnnestConfiguration(unnestExpression, null, false);
        }

        public UnnestConfiguration withFilter(RexNode condition) {
            return new UnnestConfiguration(this.expr, condition, this.discard);
        }

        public UnnestConfiguration withDiscard() {
            return new UnnestConfiguration(this.expr, this.condition, true);
        }
    }
}

