/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.inject.Inject;
import javax.annotation.Nullable;
import org.apache.calcite.schema.Schema;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.schema.SystemSchema;

public class NamedSystemSchema
implements NamedSchema {
    public static final String NAME = "sys";
    private final SystemSchema systemSchema;
    private final PlannerConfig plannerConfig;

    @Inject
    public NamedSystemSchema(PlannerConfig plannerConfig, SystemSchema systemSchema) {
        this.plannerConfig = plannerConfig;
        this.systemSchema = systemSchema;
    }

    @Override
    public String getSchemaName() {
        return NAME;
    }

    @Override
    public Schema getSchema() {
        return this.systemSchema;
    }

    @Override
    @Nullable
    public String getSchemaResourceType(String resourceName) {
        if (this.plannerConfig.isAuthorizeSystemTablesDirectly()) {
            return "SYSTEM_TABLE";
        }
        return null;
    }
}

