/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.java.util.common.Pair;

public class CombiningInputSource
extends AbstractInputSource
implements SplittableInputSource {
    public static final String TYPE_KEY = "combining";
    private final List<SplittableInputSource> delegates;

    @JsonCreator
    public CombiningInputSource(@JsonProperty(value="delegates") List<SplittableInputSource> delegates) {
        Preconditions.checkArgument((delegates != null && !delegates.isEmpty() ? 1 : 0) != 0, (Object)"Must specify at least one delegate inputSource");
        this.delegates = delegates;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        HashSet<String> types = new HashSet<String>();
        for (InputSource inputSource : this.delegates) {
            types.addAll(inputSource.getTypes());
        }
        return types;
    }

    @JsonProperty
    public List<SplittableInputSource> getDelegates() {
        return this.delegates;
    }

    public Stream<InputSplit> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return this.delegates.stream().flatMap(inputSource -> {
            try {
                return inputSource.createSplits(inputFormat, splitHintSpec).map(inputsplit -> new InputSplit<Pair<SplittableInputSource, Object>>(Pair.of(inputSource, inputsplit)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return this.delegates.stream().mapToInt(inputSource -> {
            try {
                return inputSource.estimateNumSplits(inputFormat, splitHintSpec);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).sum();
    }

    public InputSource withSplit(InputSplit split) {
        Pair inputSourceWithSplit = (Pair)split.get();
        return ((SplittableInputSource)inputSourceWithSplit.lhs).withSplit((InputSplit)inputSourceWithSplit.rhs);
    }

    @Override
    public boolean needsFormat() {
        return this.delegates.stream().anyMatch(InputSource::needsFormat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombiningInputSource that = (CombiningInputSource)o;
        return this.delegates.equals(that.delegates);
    }

    public int hashCode() {
        return Objects.hash(this.delegates);
    }
}

