/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CoalesceFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.query.filter.vector.VectorMatch;

public final class CoalesceVectorObjectProcessor
extends CoalesceFunctionVectorProcessor<Object[]> {
    private final Object[] output;

    public CoalesceVectorObjectProcessor(ExpressionType outputType, ExprVectorProcessor<Object[]>[] processors) {
        super(outputType, processors);
        this.output = new Object[processors[0].maxVectorSize()];
    }

    @Override
    public ExprEvalVector<Object[]> evalVector(Expr.VectorInputBinding bindings) {
        this.inputBindingFilterer.setBindings(bindings);
        this.inputBindingFilterer.getVectorMatch().copyFrom(VectorMatch.allTrue(bindings.getCurrentVectorSize()));
        int[] selection = this.inputBindingFilterer.getVectorMatch().getSelection();
        int currentProcessor = 0;
        int notNull = 0;
        while (notNull < bindings.getCurrentVectorSize() && currentProcessor < this.processors.length) {
            ExprEvalVector inputVector = this.processors[currentProcessor++].evalVector(this.inputBindingFilterer);
            Object[] inputValues = inputVector.getObjectVector();
            int nulls = 0;
            for (int i = 0; i < this.inputBindingFilterer.getCurrentVectorSize(); ++i) {
                int outIndex = selection[i];
                if (inputValues[i] == null) {
                    if (currentProcessor < this.processors.length) {
                        selection[nulls++] = selection[i];
                        continue;
                    }
                    this.output[outIndex] = null;
                    continue;
                }
                ++notNull;
                this.output[outIndex] = inputValues[i];
            }
            if (notNull == bindings.getCurrentVectorSize()) break;
            this.inputBindingFilterer.getVectorMatch().setSelectionSize(nulls);
        }
        return new ExprEvalObjectVector(this.output, this.outputType);
    }
}

